#ifndef MGSKYPOSITION_H
#define MGSKYPOSITION_H

//
// This File contains the declaration of the MGCoordinates-class
//
//   Author: Thomas Bretz
//   Version: V1.0 (1-8-2000)


#ifndef MGEMBEDDEDCANVAS_H
#include "MGEmbeddedCanvas.h"
#endif

#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

class TArc;
class TLine;

class ZdAz;
class RaDec;
class TText;
class SlaStars;
class SlaPlanets;

class MGSkyPosition : public MGEmbeddedCanvas
{
    TArc       *fMoon;
    TArc       *fJupiter;
    TArc       *fVenus;
    TArc       *fMars;
    TArc       *fSun;
    TArc       *fSaturn;

    TArc       *fStars[13];

    TArc       *fSaturnRing;

    TArc       *fDot[6];

    TLine      *fLin1a;
    TLine      *fLin1b;
    TLine      *fLin2;

    TLine      *fSunL[4];

    TText      *fText;

    SlaStars   *fSlaStar;
    SlaPlanets *fSlaPlanet;

    const MObservatory::LocationName_t fObservatory;

//    Int_t fStarX[13];
//    Int_t fStarY[13];

//    Int_t fPlanetX[9];
//    Int_t fPlanetY[9];

    void InitArc(TArc *arc, Int_t fillstyle, Int_t fillcolor, Int_t linecolor);

    void InitText();
    void InitPlanets();
    void InitPosition();
    void DrawCoordinateSystem();

    void SetLin1(Float_t x, Float_t y);
    void SetLin2(Float_t x1, Float_t y1, Float_t x2, Float_t y2);

    void SetDot(TArc *arc, const RaDec &radec, Int_t off);

    void UpdateStars();
    void UpdateText(Float_t zd, Float_t az);
    void UpdatePlanet(Int_t planet, TArc *arc);
    void UpdatePosition(RaDec &radec, Float_t zd, Float_t az);

public:
    MGSkyPosition(MObservatory::LocationName_t key, const TGWindow* p, const UInt_t w);
    ~MGSkyPosition();

    void Update(ZdAz &pos, double mjd);

    ClassDef(MGSkyPosition, 0)
};

#endif // MGSKYPOSITION_H
