#include "Ring.h"

#include <iostream.h>

#include "Led.h"
#include "Leds.h"

#include "Rings.h"

ClassImp(Ring);

bool Ring::CalcCenter(const Leds &leds, Int_t i, Int_t j, Int_t k)
{
    Float_t h1 = leds(i).GetY()- leds(j).GetY();

    if (h1==0)
    {
        Swap(&j, &k);
        h1 = leds(i).GetY()- leds(j).GetY();
        if (h1==0)
        {
                cout << "h1==0" <<endl;
                return kFALSE;
        }
    }

    Float_t h2 = leds(j).GetY() - leds(k).GetY();

    if (h2==0)
    {
        Swap(&i, &j);
        h2 = leds(j).GetY() - leds(k).GetY();
        if (h2==0)
        {
            cout << "h2==0" << endl;
            return kFALSE;
        }
    }

    Float_t w1 = leds(i).GetX() - leds(j).GetX();
    Float_t w2 = leds(j).GetX() - leds(k).GetX();

    Float_t m1 = -w1/h1;
    Float_t m2 = -w2/h2;

    if (m2-m1==0)
    {
        cout << "m2-m1==0" << endl;
        return kFALSE;
    }

    fX = ((m2*(leds(j).GetX() + leds(k).GetX()) + leds(i).GetY() - leds(k).GetY()       -m1*(leds(i).GetX() + leds(j).GetX()))/(m2-m1)/2);
    fY = ((m2*(leds(i).GetY() + leds(j).GetY()) +m1*m2*(leds(k).GetX() - leds(i).GetX())-m1*(leds(j).GetY() + leds(k).GetY()))/(m2-m1)/2);

    fR = sqrt(sqr(fX-leds(i).GetX())+sqr(fY-leds(i).GetY()));

    return kTRUE;
}

void Ring::InterpolCenters(const Rings &rings)
{
    const int n=rings.GetEntries();

    fX = 0;
    fX = 0;
    fR = 0;

    for (int i=0; i<n; i++)
    {
        const Ring &ring = *(Ring*)((Rings&)rings)[i];

        fX += ring.GetX();
        fY += ring.GetY();
        fR += ring.GetR();
    }

    fX /= n;
    fY /= n;
    fR /= n;

    //
    // deviation of x- and y coordinate and radius
    //
    Float_t sumx=0;
    Float_t sumy=0;
    Float_t sumr=0;

    for (int i=0; i<n; i++)
    {
        const Ring &ring = *(Ring*)((Rings&)rings)[i];

        sumx += sqr(ring.GetX()-fX);
        sumy += sqr(ring.GetY()-fY);
        sumr += sqr(ring.GetR()-fR);
    }

        fDx=sqrt(sumx)/(n-1);
        fDy=sqrt(sumy)/(n-1);
        fDr=sqrt(sumr)/(n-1);

}

