#!/bin/bash

if [[ $# < 1 ]]
then
  echo ""
  echo "FACT.sub_star_data.sh <runlist>"
  echo ""
  echo "<runlist> should be in the form YEAR MONTH DAY eg:"
  echo "2013 10 15"
  echo ""
  exit
fi

cd $MARSSYS

INFILE=$MARSSYS"/batch/"$1

while read LINE
do

  YEAR=`echo $LINE | gawk '{print $1}'`
  MONTH=`echo $LINE | gawk '{print $2}'`
  DAY=`echo $LINE | gawk '{print $3}'`

  DATE=$YEAR$MONTH$DAY
  QSUB=$MARSSYS"/batch/queue/FACT.qsub_star_data_"$DATE".sh"

  QSUBERR=$MARSSYS"/batch/queue/FACT.qsub_star_data_"$DATE".err"
  QSUBOUT=$MARSSYS"/batch/queue/FACT.qsub_star_data_"$DATE".out"

  sed -e "s|YYYYY|$YEAR|"  \
      -e "s|MMMMM|$MONTH|" \
      -e "s|DDDDD|$DAY|"   $MARSSYS"/batch/FACT.qsub_star_data.sh" > $QSUB

  chmod +x $QSUB

  ##qsub -q fact_medium -b yes -o $QSUBOUT -e $QSUBERR $QSUB
  ##qsub -q test -b yes -o $QSUBOUT -e $QSUBERR $QSUB
  qsub -b yes -o $QSUBOUT -e $QSUBERR $QSUB

done <$INFILE
