#ifndef COSY_Led
#define COSY_Led

#ifndef ROOT_TObject
#include <TObject.h>
#endif

class Ring;

class Led : public TObject
{
private:
    Double_t fX;
    Double_t fY;
    Double_t fPhi;

    Double_t fDx;
    Double_t fDy;
    Double_t fDphi;

    Double_t fMag;

public:
    Led(Double_t x=0, Double_t y=0, Double_t dx=0, Double_t dy=0, Double_t mag=0) :
        fX(x), fY(y), fDx(dx), fDy(dy), fMag(mag)
    {
    }

    Double_t GetX() const   { return fX; }
    Double_t GetY() const   { return fY; }
    Double_t GetDx() const  { return fDx; }
    Double_t GetDy() const  { return fDy; }
    Double_t GetMag() const { return fMag; }

    void CalcPhi(const Ring &ring);

    ClassDef(Led, 1)
};

#endif
