#include "Rings.h"

#include "Led.h"
#include "Leds.h"

ClassImp(Rings);

Int_t Rings::CalcCenters(const Leds &leds)
{
    int nPoints = leds.GetEntries();

    int n=0;
    for (int i=0; i<nPoints-2; i++)
        for (int j=i+1; j<nPoints-1; j++)
            for (int k=j+1; k<nPoints; k++)
            {
                Ring &ring = *(Ring*)(*this)[n];

                ring.CalcCenter(leds, i, j, k);

                n++;
            }
    return n;
}

void Rings::CalcRings(Leds &leds)
{
    CalcCenters(leds);

    fCenter.InterpolCenters(*this);

    //
    // angles v and relative angle w
    //
    for (int j=0; j<leds.GetEntries(); j++)
        leds(j).CalcPhi(fCenter);
}
