// The FACT collaboration
// Dominik Neise and Sebastian Mueller October 2014
// A callisto like CERN-Root script to process the FACT DRS 
// (Domino-Ring-Sampler) time calibration files. 
//
// The basic script is taken from the October 2014 analysis framework running on
// La Palma, maintained by Daniela Dorner and Thomas Bretz. There it was called
// "callisto_drs_time.C"

// Dominik and Sebastian:
// Our first approach was to use the MWriteFitsFile class but we have not been 
// able to use it.

// MWriteFitsFile fitsfile(outfile, 
//                 MWriteFitsFile::kSingleFile, 
//                 "RECREATE", 
//                 "fitsfile", 
//                 "atitle");
// fitsfile.SetBytesPerSample("Data", 2);
// fitsfile.AddContainer("MDrsCalibrationTime","DANDELION");

#include "MLogManip.h"

int produce_drs_time_fits_file(
    const char *drs_time_file,  //* path to raw drs-time-calib-file
    const char *drs_file,       //* path to drs.fits(.gz) file
    const char *outfile         //* output path like yyyymmdd_rrr.drs.time.fits 
){
    gLog.Separator("produce_drs_time_fits_file");
    gLog << all;
    gLog << "DRS Timing " << drs_time_file << '\n';
    gLog << "DRS 1024   " << drs_file << '\n';
    gLog << endl;

    MParList plist0;

    MTaskList tlist0;
    plist0.AddToList(&tlist0);

    MDrsCalibration drscalib1024;
    if (!drscalib1024.ReadFits(drs_file)){
        gLog << "Error while opening drs amplitude calibration file:" 
            << drs_file << "Aborting" << endl;
        return 52; // DN: Why 52 I don't know.
    }
    plist0.AddToList(&drscalib1024);
    
    MDrsCalibrationTime timecam;
    plist0.AddToList(&timecam);

    MEvtLoop loop0("DetermineTimeCal");
    loop0.SetParList(&plist0);

    MRawFitsRead read0(drs_time_file);
    tlist0.AddToList(&read0);
    MGeomApply apply0;
    tlist0.AddToList(&apply0);
    MDrsCalibApply drsapply0;
    tlist0.AddToList(&drsapply0);
    MContinue cont0("MRawEvtHeader.GetTriggerID!=33792", "SelectTim");
    tlist0.AddToList(&cont0);
    MFillH fill0("MHDrsCalibrationTime");
    fill0.SetNameTab("DeltaT");
    tlist0.AddToList(&fill0);

    if (!loop0.Eventloop(0)){
        gLog << "Error performing the loop over the drs-time-run:" 
            << drs_time_file << "Aborting" << endl;   
        return 8; // DN: why 8 I don't know.
    }

    timecam.WriteToFits(outfile);

    return 0;
}
