#include "MCsvTextFile2FloatMatrixParser.h"

ClassImp(MCsvTextFile2FloatMatrixParser);
// --------------------------------------------------------------------------
//
// Default constructor
//
MCsvTextFile2FloatMatrixParser::MCsvTextFile2FloatMatrixParser(
	const char *name, const char *title)
{
    if( name == NULL ){
    	std::cerr << "MCsvTextFile2FloatMatrixParser::MCsvTextFile2FloatMatrixParser:\n";
		std::cerr << "The name string is pointing to NULL!\n";
    	std::exception bad_name;
        throw bad_name;
    }else{
        fName  = name;          
    }

    fTitle = title ? title : "Parameter container storing a vector of vectors to hold floating numbers";
}
// --------------------------------------------------------------------------
//
// text file parser
//
void MCsvTextFile2FloatMatrixParser::ParseCsvFile(
	const std::string path_to_text_file )
{
	// make sure the data Matrix M is wiped out before new data is read.
	clear();

	std::ifstream csv_input_file( path_to_text_file, std::ifstream::in);

	if( !csv_input_file.is_open() ){
		// a file which can not be opened must not pass silent!
		std::exception cant_opne_file;
    	std::cerr << "MCsvTextFile2FloatMatrixParser::ParseCsvFile:\n";
		std::cerr << "The file: "<< csv_input_file <<" could no be opened!\n";
        throw cant_opne_file;	
	}else{
		//as long as there are lines in the file:
		std::string line;
        while ( getline(csv_input_file, line ) ){

        	std::stringstream line_stream(line);
        	//line_stream << line;
        	std::string token;
			
			std::vector< double > row;
        	//as long as there are tokens in a line:
			while( getline(line_stream, token,',')){

				// remove tailing whitespaces
				token.erase( 
					std::remove_if( 
						token.begin(), 
						token.end(), 
						::isspace 
						),
				 	token.end() 
				 );

				row.push_back(pedantic_str2float(token));
			}

			M.push_back( row );
        }
	}
	csv_input_file.close();
	filename = path_to_text_file;
}
// --------------------------------------------------------------------------
//
// a pedantic string to float converter
//
double MCsvTextFile2FloatMatrixParser::pedantic_str2float(std::string text)const{

	if(text.compare("")==0){
		std::exception error;
		std::cerr << "MCsvTextFile2FloatMatrixParser::pedantic_str2float:\n";
		std::cerr << "Parsing error in file: "<< filename <<"\n";		
		std::cerr << "The string given to be converted to a flot is empty! \n";
		throw error;
	}
	
	char * e;
	double FloatingNumber = std::strtod(text.c_str(), &e);
	if (*e != 0) {
		std::exception error;
    	std::cerr << "MCsvTextFile2FloatMatrixParser::pedantic_str2float:\n";
  		std::cerr << "Parsing error in file: "<< filename <<"\n";	
		std::cerr << "The given string: " << text <<" can not be converted \n";
		std::cerr << "to an floating point number!\n";
		throw error;
	}
	return FloatingNumber;
}
// --------------------------------------------------------------------------
//
// clear the Matrix
//
void MCsvTextFile2FloatMatrixParser::clear(){
	for(unsigned int row=0; row<M.size(); row++){ M[row].clear(); }
	M.clear();
}
// --------------------------------------------------------------------------
//
// display M for debug usage
//
void MCsvTextFile2FloatMatrixParser::prompt()const{
	std::stringstream info;
	info << std::fixed << std::setprecision( 4 );
	info << " ___MCsvTextFile2FloatMatrixParser.prompt()____________________\n";
	info << "| \n";
	for(unsigned int row=0; row<M.size(); row++){
		info << "| "<< row <<" ";
		for(unsigned int col=0; col<M[row].size(); col++){
			info << "[" << M[row][col] << "] ";
		}
		info << "\n";
	}
	info << "|______________________________________________________________\n";

	std::cout << info.str();
}