#ifndef COSY_MGPngReader
#define COSY_MGPngReader

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif
#include "PixClient.h"
#ifndef MARS_MObservatory
#include "MObservatory.h"
#endif

#include "MGList.h"
#include "MGImage.h"

#include <TH1.h>
#include <TH2.h>
#include <TGraph.h>
#include <TCanvas.h>

class AltAz;
class RaDec;

class TTimer;

class MGMenuBar;
class MGPopupMenu;
class TGTextEntry;

class MGImage;
class MGCoordinates;

class StarCatalog;
class MStarList;

class TFile;
class TTree;
class TBranch;

class Leds;
class Rings;

class MGPngReader : public PixClient, public TGMainFrame
{
private:
    MGList        *fList;

    MGMenuBar     *fMenu;
    MGImage       *fImage;
    MGImage       *fZoomImage;

    MGPopupMenu   *fDisplay;
    MGPopupMenu   *fWrite;
    MGPopupMenu   *fWritePictures;
    MGPopupMenu   *fFileType;
    MGPopupMenu   *fWriteType;
    MGPopupMenu   *fAnalyse;
    MGPopupMenu   *fCaOs;
    MGPopupMenu   *fWriteRate;
    MGPopupMenu   *fInterpol;
    MGPopupMenu   *fSetup;
    MGPopupMenu   *fLimMag;

    TFile         *fFile;
    TTree         *fTree;
    TBranch       *fBranchL;
    TBranch       *fBranchT;
    TBranch       *fBranchR;

    Leds *fLeds;
    Rings *fRings;
    Double_t fTime;

    TH1F          *fHistpr;
    TH1F          *fHistprx;
    TH1F          *fHistpry;
    TH1F          *fHistw[6];
    TH1F          *fHistallw;
    TH1F          *fHistv[6];

    TH2F          *fHistprxpry;

    TGraph        *fGraphprx;
    TGraph        *fGraphpry;
    TGraph        *fGraphw[6];

    MGCoordinates *fCRaDec;
    MGCoordinates *fCZdAz;

    TGTextEntry   *fPixSize;

    StarCatalog   *fSao;

    RaDec *fRaDec;

    TTimer *fTimer;

    Int_t fDx;
    Int_t fDy;

    int fIntRate;
    int fWrtRate;

    void SetPixSize(const double pixsize);
    void Toggle(MGPopupMenu *p, UInt_t id);
    void GetCoordinates();
    void CalcTrackingError(MStarList &, MStarList &);

    void InitHists();
    void InitGraphs();
    void InitGui();

    void OpenFile();

    void ResetHists();
    void DisplayAnalysis();

    Bool_t HandleTimer(TTimer *t);
    //Bool_t HandleKey(Event_t* event);

    void DrawCircle(byte *img, double r);

public:
    MGPngReader(MObservatory::LocationName_t obs);
    virtual ~MGPngReader();

    //void Update();

    void Layout();
    void CloseWindow();

    Bool_t ProcessMessage(Long_t msg, Long_t parm1, Long_t parm2);
    Bool_t HandleDoubleClick(Event_t *event);

    //
    // Execution of one frame - this function may be overloaded!
    //
    void ProcessFrame(const unsigned long n, byte *img, struct timeval *tm);

    ClassDef(MGPngReader, 0)
};

#endif
