#!/bin/bash

# completely new version of the script 
# running on newdaq to fill the information as fast as possible
# ftools is not used in this script anymore

# todo
# tempfile for fitsdump -h output

# option whether to fill all row or only those where information is missing
# $doupdate might be given as environment variable
if [ "$doupdate" = "" ]
then
   doupdate="yes" # update all entries (needed when new fields have been added)
   doupdate="no" # fill only entries which are not yet existing (default)
fi

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0 with options doupdate="$doupdate #" and skipmd5sum="$skipmd5sum

# check if software is available
if ! ls $factpath/fitsdump >/dev/null 2>&1
then 
   printprocesslog "ERROR "$factpath"/fitsdump is not available."
   finish
fi

# check if paths are available
if ! ls $rawdata >/dev/null 2>&1
then 
   printprocesslog "ERROR "$rawdata" is not available."
   finish
fi

# get dates
if [ "$certaindate" != "" ]
then
   checkstring=`echo $certaindate | grep -E -o '^20[0-9][0-9]\/[01][0-9]\/[0-3][0-9]$'`
   if [ "$checkstring" = "" ]
   then
      echo "Please give the variable certaindate in the correct format (YYYY/MM/DD)"
      finish
   fi
   getdates $certaindate
else
   # get all night
   #getdates "all"
   # get last 6 nights if hour between 7 and 19h, else only current night
   getdates 6 7 19
fi

# do check for rawfiles of these dates
for date in ${dates[@]}
do 
   # get runnumber from date
   runnumber=`echo $date | sed -e 's/\///g'`
   
   night=
   query="SELECT fNight FROM AuxDataInsertStatus WHERE fNight="$runnumber
   night=`sendquery`
   if [ "$night" == "" ] && ls $rawdata/$date >/dev/null 2>&1
   then
      printprocesslog "INFO insert "$runnumber" to AuxDataInsertStatus"
      query="INSERT AuxDataInsertStatus SET fNight="$runnumber", fPriority="$runnumber
      sendquery >/dev/null 2>&1
   fi
   rawdir=$rawdata/$date
   # check if data are available from that night
   if ! [ -d $rawdir ]
   then
      printprocesslog "INFO "$rawdir" does not exist."
      continue
   else
      printprocesslog "INFO processing "$rawdir"..."
   fi

   # find all fits.gz files starting with the oldest file
   printprocesslog "INFO finding files to be checked in $rawdir..."
   #fitsfiles=`ls $rawdir/*.fits 2>/dev/null | sort `
   fitsfiles=( `find $rawdir -type f -regex '.*20[0-9][0-9][01][0-9][0-3][0-9][_][0-9][0-9][0-9][.]fits[.]?[g]?[f]?[z]?' 2>/dev/null | sort ` )

   # loop to check files
   for file in $fitsfiles
   do
      printprocesslog "INFO checking file "$file
      #echo "INFO checking file "$file
      filenotclosed="no"

      # check if it is drs file
      isdrs=`ls $file | grep drs`
      if [ "$isdrs" != "" ]
      then
         printprocesslog "INFO "$file" is a drs file. -> continue"
         continue
      fi

      # get run and file number form filename
      numberfromname=`echo $file | grep -E -o '20[1-9][0-9][01][0-9][0-3][0-9]_[0-9]{3}'`
      runnumberfromname=`echo $numberfromname | cut -d_ -f1`
      filenumberfromname=`echo $numberfromname | cut -d_ -f2 | sed -e 's/^0//g' -e 's/^0//g'`
      if [ "$runnumber" != "$runnumberfromname" ]
      then
         printprocesslog "ERROR for file "$file": runnumber from date ("$runnumber") and filename ("$runnumberfromname") don't agree."
      fi
      
      # check if entry already exists
      query="SELECT fNight FROM RunInfo WHERE Concat(fNight, '_', LPAD(fRunID, 3, 0))='"$numberfromname"'"
      printprocesslog "DEBUG check if entry already exists in DB. QUERY: "$query
      #result3=`/usr/bin/mysql -u operator --host=fact01.fact.local --password=$password FactData -e "$query3"`
      result3=`sendquery`

      # only proceed with file 
      #  if information is not yet in database
      #  and no update is wished ($doupdate)
      if [ "$result3" != "" ] && [ "$doupdate" == "no" ]
      then 
         printprocesslog "INFO "$file" has been inserted already. -> continue "
         continue
      fi
      
      runtype=
      # check if file was closed properly
      if [ "`echo $file | grep -o drs`" == "drs" ]
      then
         nondrsfile=`echo $file | sed -e 's/[.]drs//g'`".fz" # fixme: maybe more flexible
         tstop=`$factpath/fitsdump -h $nondrsfile  2>/dev/null | grep TSTOPI | grep -E -o '[0-9]+'`
         checkstatus=$?
      else
         tstop=`$factpath/fitsdump -h $file  2>/dev/null | grep TSTOPI | grep -E -o '[0-9]+'`
         checkstatus=$?
      fi
      #if [ $checkstatus -gt 0 ]
      #then
      #   echo "WARN: getting tstop for file "$file" failed: tstop: -"$tstop"-"`date`
      #fi
      if [ "$tstop" == "0" ] || [ "$tstop" == "" ]
      then
         fileaccessed=`find $file -amin -30`
         if ! [ "$fileaccessed" == "" ]
         then
            printprocesslog "INFO "$file" was accessed in the last 30 minutes => continue"
            continue
         else
            printprocesslog "WARN "$file" has empty TSTOP but was not touched for 30 minutes"
            filenotclosed="yes"
         fi
      fi

      numdrsfiles=
      step=
      if [ "$filenotclosed" == "no" ]
      then 
         # get run and file number from file
         runnumberfromfile=`$factpath/fitsdump -h $file 2>/dev/null | grep NIGHT | grep -E -o '20[1-9][0-9][01][0-9][0-3][0-9]'`
         filenumberfromfileorig=`$factpath/fitsdump -h $file 2>/dev/null | grep RUNID | grep -E -o '[0-9]{1,3}'`
         if [ "$runnumberfromfile" = "" ] || [ "$filenumberfromfileorig" = "" ]
         then
            printprocesslog "ERROR couldn't get run or file number from file name ("$file")."
         fi
         numberfromfile=$runnumberfromfile"_"`printf %03d $filenumberfromfileorig`
         # compare numbers
         if [ "$numberfromfile" != "$numberfromname" ]
         then
            printprocesslog "ERROR for file "$file": number from filename ("$numberfromname") and file ("$numberfromfile") don't agree."
         fi
      
         # get checksums from header
         checksum=`$factpath/fitsdump -h $file  2>/dev/null | grep CHECKSUM | grep -E -o '[a-zA-Z0-9]{16}'`
         if [ "$checksum" == "" ]
         then 
            printprocesslog "WARN checksum for file "$file" is empty."
         fi
         datasum=`$factpath/fitsdump -h $file  2>/dev/null | grep DATASUM | grep -E -o '[0-9]{1,10}'`
         if [ "$datasum" == "" ]
         then 
            printprocesslog "WARN datasum for file "$file" is empty."
         fi
         
         # check if this run has drs file
         #   in case file is available, get STEP from header
         # in the very beginning only drs-files were existing
         # in the beginning the keywords DRSCALIB and STEP were not existing
         drsfile=`echo $file | sed -e 's/fits.fz/drs.fits/'`
         numdrsfiles=`ls $drsfile 2>/dev/null | wc -l`
         drscalib=`$factpath/fitsdump -h $file  2>/dev/null | grep DRSCALIB | grep -E -o "[\ ][TF][\ ]" | sed -e "s/\ //g"`
         if [ "$drscalib" == "T" ]
         then 
            step=`$factpath/fitsdump -h $file  2>/dev/null | grep DRSSTEP | grep -E -o "[\ ][012][\ ]" | sed -e "s/\ //g"`
            stepfromdrs=`$factpath/fitsdump -h $drsfile  2>/dev/null | grep STEP | grep -E -o "[\ ][012][\ ]?" | sed -e "s/\ //g"`
            if [ "$stepfromdrs" != "$step" ]
            then
               printprocesslog "ERROR for file "$file" step from drsfile ("$stepfromdrs") and from file ("$step") do not agree."
               if [ "$stepfromdrsfile" != "" ] && [ "$step" == "" ]
               then 
                  step=$stepfromdrsfile
                  printprocesslog "WARN setting drsstep from drsfile ("$stepfromdrs") although value differs from the one in file "$file"."
               fi
            fi
            if ! [ $numdrsfiles -eq 1 ]
            then 
               printprocesslog "ERROR for file "$file" number of drsfiles ("$numdrsfiles") and information from header ("$drscalib") don't agree."
            fi
            if [ "$step" = "" ]
            then 
               printprocesslog "ERROR file "$file" has drsfiles ("$numdrsfiles"), but step ("$step") is empty."
            fi
         else
            if ! [ "$drscalib" == "F" ]
            then
               printprocesslog "WARN for file "$file" DRSCALIB is neither T nor F."
            fi
         fi
         
         # get other variables from header 
         runtype=`$factpath/fitsdump -h $file  2>/dev/null | grep RUNTYPE | grep -E -o "['][a-z0-9._-]+[']" | sed -e "s/'//g" -e "s/_/-/g" -e "s/[.]//g"`
         roi=`$factpath/fitsdump -h $file  2>/dev/null | grep NROI | grep -v NROITM | grep -E -o '[0-9]{1,4}'`
         roitm=`$factpath/fitsdump -h $file  2>/dev/null | grep NROITM | grep -E -o '[0-9]{1,4}'`
         numevents=`$factpath/fitsdump -h $file  2>/dev/null | grep Events | grep -E -o '[0-9]+'`
         numphys=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRG ' | grep -E -o '[0-9]+'`
         numext1=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGEXT1' | grep -E -o '[ ][0-9]+[ ]' | sed -e 's/\ //g'`
         numext2=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGEXT2' | grep -E -o '[ ][0-9]+[ ]' | sed -e 's/\ //g'`
         numelp=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGLPE' | grep -E -o '[0-9]+'`
         numilp=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGLPI' | grep -E -o '[0-9]+'`
         numoth=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGMISC' | grep -E -o '[0-9]+'`
         numped=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGPED' | grep -E -o '[0-9]+'`
         numtime=`$factpath/fitsdump -h $file  2>/dev/null | grep 'NTRGTIM' | grep -E -o '[0-9]+'`
         compiled=`$factpath/fitsdump -h $file  2>/dev/null | grep 'COMPILED' | grep -E -o "['][a-zA-Z]+[ ][ 12][0-9][ ]20[0-9][0-9][ ][0-2][0-9]:[0-5][0-9]:[0-5][0-9][']" | sed -e "s/'//g"`
         if ! [ "$compiled" == "" ]
         then 
            compiletime=`date +'%F %H:%M:%S' --date="${compiled}" `
         else
            compiletime=
         fi
         revnum=`$factpath/fitsdump -h $file  2>/dev/null | grep 'REVISION' | grep -E -o "['][0-9]+[:]?[0-9]*[MSP]*[']" | sed -e "s/'//g"`
         # in newest data start time is in DATE-OBS
         # in older data start time is in TSTART
         # in the beginning TSTART was empty
         runstart=`$factpath/fitsdump -h $file  2>/dev/null | grep DATE-OBS | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         runstart2=`$factpath/fitsdump -h $file  2>/dev/null | grep TSTART | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         if [ "$runstart" == ""  ]
         then
            if [ "$runstart2" == ""  ]
            then
               # for very old data, but gives problems for newer data
               #runstart=`$factpath/fitsdump -h $file  2>/dev/null | grep DATE | grep -v 'DATE-' | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
               runstart="0000-00-00 00:00:00"
            else
               runstart=$runstart2
            fi
         fi
         # in newest data start time is in DATE-END
         # in older data start time is in TSTOP
         # in the beginning TSTOP was empty
         runstop=`$factpath/fitsdump -h $file  2>/dev/null | grep DATE-END | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         runstop2=`$factpath/fitsdump -h $file  2>/dev/null | grep TSTOP | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9]T[0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{6}'`
         if [ "$runstop" == ""  ]
         then
            if [ "$runstop2" == ""  ]
            then
               # for very old data, but gives problems for newer data
               #runstop=`stat $file  2>/dev/null | grep Modify | grep -E -o '20[1-9][0-9][\-][01][0-9][\-][0-3][0-9][ ][0-2][0-9]:[0-6][0-9]:[0-6][0-9][.][0-9]{9}'`
               runstop="0000-00-00 00:00:00"
            else
               runstop=$runstop2
            fi
         fi
      fi
      
      # set runtype to 'unknown', if no runtype could be retrieved from file
      if [ "$runtype" == "" ]
      then
         runtype="n/a"
      fi
      # on 15.11.2011 the runtypes had different names
      if [ "$date" == "2011/11/15" ]
      then
         if [ "$runtype" == "drs-calib" ]
         then
            runtype="drs-gain"
         fi
         if [ "$runtype" == "drs-time-calib" ]
         then
            runtype="drs-time"
         fi
         if [ "$runtype" == "pedestal" ]
         then
            runtype="drs-pedestal"
         fi
         if [ "$runtype" == "light-pulser" ]
         then
            runtype="light-pulser-ext"
         fi
         if [ "$runtype" == "pedestal-on" ]
         then
            runtype="pedestal"
         fi
      fi
      # get runtype
      query="SELECT fRunTypeKEY FROM RunType WHERE fRunTypeName='"$runtype"'"
      printprocesslog "DEBUG get run type from DB. QUERY:"$query
      result2=( `sendquery` )
      if [ ${#result2} -eq 0 ]
      then 
         printprocesslog "ERROR "$numberfromname": Could not query fRunTypeKey for runtype "$runtype" ."
         continue
      fi

      # insert or update depending on whether run exists
      if [ "$result3" == "" ]
      then 
         query="INSERT"
         querymid=" fNight="$runnumber", fRunID="$filenumberfromname", "
         querystop=
      else
         query="UPDATE"
         querymid=
         querystop=" WHERE fNight="$runnumber" AND fRunID="$filenumberfromname
      fi
      query=$query" RunInfo SET "$querymid" fRunTypeKey="${result2[0]}
      if [ "$filenotclosed" == "no" ]
      then 
         query=$query", fRunStart='"$runstart"', fRunStop='"$runstop"'"
         if [ "$numevents" != "" ]
         then
            query=$query", fNumEvents="$numevents
         fi
         if [ "$roi" != "" ]
         then
            query=$query", fROI="$roi
         fi
         if [ "$roitm" != "" ]
         then
            query=$query", fROITimeMarker="$roitm
         fi
         if [ "$numphys" != "" ]
         then
            query=$query", fNumPhysicsTrigger="$numphys
         fi
         if [ "$numext1" != "" ]
         then
            query=$query", fNumExt1Trigger="$numext1
         fi
         if [ "$numext2" != "" ]
         then
            query=$query", fNumExt2Trigger="$numext2
         fi
         if [ "$numelp" != "" ]
         then
            query=$query", fNumELPTrigger="$numelp
         fi
         if [ "$numilp" != "" ]
         then
            query=$query", fNumILPTrigger="$numilp
         fi
         if [ "$numped" != "" ]
         then
            query=$query", fNumPedestalTrigger="$numped
         fi
         if [ "$numtime" != "" ]
         then
            query=$query", fNumTimeTrigger="$numtime
         fi
         if [ "$numoth" != "" ]
         then
            query=$query", fNumOtherTrigger="$numoth
         fi
      fi
      if [ "$checksum" != "" ]
      then
         query=$query", fCheckSum='"$checksum"'"
      fi
      if [ "$datasum" != "" ]
      then
         query=$query", fDataSum='"$datasum"'"
      fi
      if [ "$numdrsfiles" != "" ]
      then
         query=$query", fHasDrsFile="$numdrsfiles
      fi
      if [ "$step" != "" ]
      then
         query=$query", fDrsStep="$step
      fi
      if [ "$compiletime" != "" ]
      then
         query=$query", fCompileTime='"$compiletime"'"
      fi
      if [ "$revnum" != "" ]
      then
         query=$query", fRevisionNumber='"$revnum"'"
      fi
      #query=$query", fFitsFileErrors="$numfitserrors
      query=$query" "$querystop
      # send query to DB
      #echo $query
      sendquery >/dev/null
   done
done

finish

