#include <fcntl.h>
#include <termios.h>
#include <stdio.h>
 
// For Evidence server
#define SERVER_NAME "ARDUINO"	// Name to use in DIM
#include "Evidence.h"
#define NUM_VAL 10

#define MODEMDEVICE "/dev/myArduino"

int main() {

  int fd, res;
  struct termios oldtio,newtio;
  char Textbuffer[255], Temp[sizeof(Textbuffer)], *Token;

  // Start Evidence server and create services
  EvidenceServer Srv(SERVER_NAME);

  float Val[NUM_VAL]={0};
  DimService TextService(SERVER_NAME"/Textout", Textbuffer);
  DimService Data(SERVER_NAME"/Data", "F", Val, sizeof(Val));

  //  Open modem device for reading and writing and not as controlling tty
  //  because we don't want to get killed if linenoise sends CTRL-C.
  fd = open(MODEMDEVICE, O_RDWR | O_NOCTTY ); 
  if (fd <0) {
	Srv.State(Srv.FATAL, "Could not open modem device (%s)", strerror(errno));
  }

  tcgetattr(fd,&oldtio); /* save current serial port settings */
  memset(&newtio, 0, sizeof(newtio)); /* clear struct for new port settings */

  /* 
     BAUDRATE: Set bps rate. You could also use cfsetispeed and cfsetospeed.
     CRTSCTS : output hardware flow control (only used if the cable has
               all necessary lines. See sect. 7 of Serial-HOWTO)
     CS8     : 8n1 (8bit,no parity,1 stopbit)
     CLOCAL  : local connection, no modem contol
     CREAD   : enable receiving characters
   */
  newtio.c_cflag = B9600 |  CS8 | CLOCAL | CREAD;

  //  CRTSCTS |  maybe not needed //DN 090907

  /*
    IGNPAR  : ignore bytes with parity errors
    ICRNL   : map CR to NL (otherwise a CR input on the other computer
              will not terminate input)
    otherwise make device raw (no other input processing)
  */
  newtio.c_iflag = IGNPAR ;
        
  // | ICRNL // i guess this is not needed here. DN 090907

  // Raw output.
  newtio.c_oflag = 0;

  /*
    ICANON  : enable canonical input
    disable all echo functionality, and don't send signals to calling program
  */
  newtio.c_lflag = ICANON;
         
  /* 
    initialize all control characters 
    default values can be found in /usr/include/termios.h, and are given
    in the comments, but we don't need them here
  */
  newtio.c_cc[VINTR]    = 0;     /* Ctrl-c */ 
  newtio.c_cc[VQUIT]    = 0;     /* Ctrl-\ */
  newtio.c_cc[VERASE]   = 0;     /* del */
  newtio.c_cc[VKILL]    = 0;     /* @ */
  newtio.c_cc[VEOF]     = 4;     /* Ctrl-d */
  newtio.c_cc[VTIME]    = 0;     /* inter-character timer unused */
  newtio.c_cc[VMIN]     = 1;     /* blocking read until 1 character arrives */
  newtio.c_cc[VSWTC]    = 0;     /* '\0' */
  newtio.c_cc[VSTART]   = 0;     /* Ctrl-q */ 
  newtio.c_cc[VSTOP]    = 0;     /* Ctrl-s */
  newtio.c_cc[VSUSP]    = 0;     /* Ctrl-z */
  newtio.c_cc[VEOL]     = 0;     /* '\0' */
  newtio.c_cc[VREPRINT] = 0;     /* Ctrl-r */
  newtio.c_cc[VDISCARD] = 0;     /* Ctrl-u */
  newtio.c_cc[VWERASE]  = 0;     /* Ctrl-w */
  newtio.c_cc[VLNEXT]   = 0;     /* Ctrl-v */
  newtio.c_cc[VEOL2]    = 0;     /* '\0' */
 
  //  now clean the modem line and activate the settings for the port
  tcflush(fd, TCIFLUSH);
  tcsetattr(fd,TCSANOW,&newtio);

  while (!Srv.ExitRequest) {

  /* read blocks program execution until a line terminating character is 
     input, even if more than 255 chars are input. If the number
     of characters read is smaller than the number of chars available,
     subsequent reads will return the remaining chars. res will be set
     to the actual number of characters actually read */
    res = read(fd, Textbuffer, sizeof(Textbuffer)); 

	// Set end of string marker anbd replace all non-printable characters
    Textbuffer[res]=0;
	for (unsigned int i=0; i<strlen(Textbuffer); i++) if (isprint(Textbuffer[i])==0) Textbuffer[i] = ' ';

	printf("%s\n", Textbuffer);
	TextService.updateService();
	if (strncmp (Textbuffer,"[Temp,",6) != 0) continue;

	// Update DIM services
	memcpy(Temp, Textbuffer, sizeof(Textbuffer));
	Token = strtok(Temp, ", ");  
	for (int i=0; i<NUM_VAL; i++) {
	  Token = strtok(NULL, ", ");
	  if (Token != NULL) Val[i] = atof(Token);
    }
	Data.updateService();

	usleep(atoi(Srv.GetConfig("Period", "10")) * 1000000);	
  } // while()
       
  /* restore the old port settings */
  tcsetattr(fd,TCSANOW,&oldtio);
}
