#ifndef MARS_MEnergyTable
#define MARS_MEnergyTable

#ifndef MARS_MTask
#include "MTask.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

#include <vector>
#include "TH2F.h"

#define D2R 3.1415/180.

#ifndef MARS_MParameterCalc
#include "MParameterCalc.h"
#endif

using namespace std;

class MHillasSrc;
class MEnergyEst;
class MHillas;
class MNewImagePar;
class MMcEvt;
class MHMatrix;
class MPointingPos;
class MParameterD;

class MEnergyTable : public MParameterCalc
{
private:

    MParameterD   *fParameter;
    MHillasSrc    *fHillasSrc;
    MHillas       *fHillas;
    MPointingPos  *fPointing;
    MMcEvt        *fMC;

    TString   fNameHillasSrc;
    TString   fNameHillas;
    TString   fNamePoint;
    TString   fNameMC;
    TString   fNameParameter;

    Double_t fMm2Deg;

    Int_t PreProcess(MParList *plist);
    Int_t Process();

    TFile *fTableFile;

    char sHistDir[500];
    char sHistName[500];
    int iZen[3];
    int iThr[3];

    vector<TH2F *> htemp;
    vector< vector<TH2F *> > hEnergy;

    Float_t fZenith;
    float fThreshold;
    Int_t iZenith;
    Int_t iThreshold;
    Int_t iX;
    Int_t iY;
    float fEnergy1;
    float fEnergy2;
    float fEnergyRecon;

public:

    MEnergyTable(const char *name=NULL, const char *title=NULL);
    ~MEnergyTable();

    Int_t SetTableFile( const TString sTableFile );

    ClassDef(MEnergyTable, 0) // Task to estimate the energy

};

#endif








