#ifndef CAOSFILTER_H
#define CAOSFILTER_H

#ifndef __CINT__
#include <TROOT.h>
#endif

typedef unsigned char byte;

class Leds;

class CaosFilter
{
    static void  DrawBox(const int x1, const int y1,
                         const int x2, const int y2,
                         byte *buffer, const int col);

    static void  MarkPoint(const int x, const int y,
                           byte *buffer, const int col);

    static float Mean(const byte *buffer, const int offset,
                      int *min, int *max);

    static float SDev(const byte *buffer, const int offset,
                      const double mean);

    static int   GetMeanPosition(const byte *bitmap,
                                 const int x, const int y,
                                 const int box);

    static int   GetMeanPosition(const byte *bitmap, const int x, const int y,
                                 const int box, Float_t &mx, Float_t &my);

    static bool  CalcCenter(Float_t *px, Float_t *py, Float_t &cx, Float_t &cy, Float_t &R);

    static void  InterpolCenter(int &m, Float_t *x, Float_t *y, Float_t &px, Float_t &py,
                                Float_t &pr, Float_t &sx, Float_t &sy, Float_t &sr);

    static void  CalcRings(int &m, Float_t *x, Float_t *y, Float_t &px, Float_t &py,
                           Float_t &pr, float *v, float *w);

    static int   FilterLeds(float *xw, float *yw, float *xl, float *yl);


public:
    static void Execute(byte *img, float *xw, float *yw, float *xl, float *yl,
                        float &prx, float &pry, float &pr, float *v, float *w);

    static void Execute(byte *img, Leds &leds, Double_t conv);

    static void FilterLeds(Leds &leds);
    static void RemoveTwins(Leds &leds, Double_t radius);

    ClassDef(CaosFilter, 0)
};

#endif
