/*
 * MTraceOut.cpp
 *
 *  Created on: 07.05.2015
 *      Author: dominik
 */

#include "MDebugOut.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

#include "MMcEvt.hxx"

#include "MRawRunHeader.h"

#include "MCorsikaRunHeader.h"
#include "MCorsikaEvtHeader.h"

#include "MMcRunHeader.hxx"
#include "MMcCorsikaRunHeader.h"

#include "MPhotonEvent.h"
#include "MPhotonData.h

ClassImp(MDebugOut);

MDebugOut::MDebugOut() {
	// TODO Auto-generated constructor stub

}

// MTask
Int_t MDebugOut::PreProcess(MParList *plist)
{
	fEvtHeader = (MCorsikaEvtHeader*) plist->FindObject("MCorsikaEvtHeader");
	if (!fEvtHeader)
	{
		*fLog << err << "MCorsikaEvtHeader not found... aborting." << std::endl;
		return kFALSE;
	}

	fRunHeader = (MCorsikaRunHeader*) plist->FindObject("MCorsikaRunHeader");
	if (!fRunHeader)
	{
		*fLog << err << "MCorsikaRunHeader not found... aborting." << std::endl;
		return kFALSE;
	}

	fEvt = (MPhotonEvent*) plist->FindObject("MPhotonEvent");
	if (!fEvt)
	{
		*fLog << err << "MPhotonEvent not found... aborting." << endl;
		return kFALSE;
	}

	fStat = (MPhotonStatistics*) plist->FindObject("MPhotonStatistics");
	if (!fStat)
	{
		*fLog << err << "MPhotonStatistics not found... aborting." << endl;
		return kFALSE;
	}


	return kTRUE;
}

Bool_t MDebugOut::ReInit(MParList *pList)
{
	return kTRUE;
}

Int_t MDebugOut::Process()
{
	std::cout << "";
	return kTRUE;
}
