#ifndef MARS_MMcCT1CollectionAreaCalc
#define MARS_MMcCT1CollectionAreaCalc

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MParList;
class MMcEvt;
class MHMcCT1CollectionArea;

class MMcCT1CollectionAreaCalc : public MTask
{
private:
    const MMcEvt  *fMcEvt;

    MHMcCT1CollectionArea *fCollArea;

    TString fObjName;

    UInt_t fTotalNumSimulatedShowers;
    Bool_t fAllEvtsTriggered;
    Bool_t fAllEvtsAtSameTheta;
    Float_t fTelescopeTheta;

public:
    MMcCT1CollectionAreaCalc(const char *input=NULL,
                          const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MMcCT1CollectionAreaCalc, 0) // Task to calculate the collection area histogram
};

#endif 
