#ifndef MARS_MHMcCT1CollectionArea
#define MARS_MHMcCT1CollectionArea

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TH2D;


class MHMcCT1CollectionArea : public MParContainer
{
private:
    TH2D *fHistAll; //! all simulated showers
    TH2D *fHistSel; //! the selected showers
    TH2D *fHistCol; //  the collection area
    void SetBins(Int_t nbins, Axis_t minEnergy, Axis_t maxEnergy);

public:
    MHMcCT1CollectionArea(const char *name=NULL, const char *title=NULL, Int_t nbins=45, Axis_t minEnergy=100., Axis_t maxEnergy=30000.);
    ~MHMcCT1CollectionArea();

    void FillSel(Double_t energy, Double_t radius);

    void DrawAll(Option_t *option="");
    void DrawSel(Option_t *option="");

    const TH2D *GetHist() const { return fHistCol; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    void CalcEfficiency();

    ClassDef(MHMcCT1CollectionArea, 1)  // Data Container to calculate Collection Area
};

#endif




