void dust(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    Float_t dust;
    file.SetPtrAddress("Time", &time);
    file.SetPtrAddress("Dust", &dust);

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    TGraph g;
    while (file.GetNextRow())
        g.SetPoint(g.GetN(), time+offset, dust);

    cout << "result " << MSpline3(g).Eval((beg+end)/2) << endl;
}
