var indico_url = "https://indico.scc.kit.edu/indico/";
var default_event = 215;

function process(ID, result)
{
    if (window.location.href.indexOf("debug")>=0)
        $('#debug').append("<pre>"+JSON.stringify(result,null,2)+"</pre>");

    $("#indico-link").attr("href", indico_url+"/event/"+ID)

    var conf = result['results'][ID];

    var list = "";

    // Sort the days into the correct order
    var days = [];
    for (var day in conf)
        days.push([ day, conf[day] ]);
    days.sort(function(a, b) { return a[0] > b[0]; });

    for (var d=0; d<days.length; d++)
    {
        var day = days[d][0]; // "20161206"

        // Convert "20161206" -> "2016/12/06"
        var date = day.substr(0, 4)+"&thinsp;/&thinsp;"+day.substr(4, 2)+"&thinsp;/&thinsp;"+day.substr(6,2);

        // Date accordion
        list += "<div class='indico' data-role='collapsible' data-theme='b' data-inset='false'>";
        list += "<h1>"+date+"</h1>";
        //list += "<div id='"+day+"' data-role='collapsible-set' data-filter='true' data-input='#filter' data-mini='true' data-theme='a' data-content-theme='a'>";

        var content = days[d][1];

        // Sort all slots in a days by startDate/time
        var slots = [];
        for (var slot in content)
            slots.push([ content[slot].startDate.time, content[slot]]);
        slots.sort(function(a, b) { return a[0] > b[0]; });

        // Loop over all slots (sessions)
        for (var s=0; s<slots.length; s++)
        {
            var e = slots[s][1]; // entry

            // Accordion for each session
            list += "<div class='session' data-role='collapsible' data-inset='false'>";
            list +=    "<h1 class='date'>"+e.startDate.time.substr(0,5)+"&thinsp;-&thinsp;"+e.endDate.time.substr(0,5)+"&ensp;"+e.title+"</h1>";
            //list +=    "<h1 class='date'>"+e.startDate.time.substr(0,5)+" ["+e.duration+"'] "+e.title+"</h1>";
            //list +=    "<h1 class='date'>"+e.startDate.time.substr(0,5)+" - "+e.endDate.time.substr(0,5)+" ["+e.duration+"'] "+e.title+"</h1>";


            // =======================================================
            list +=    "<div class='body'>";


            // -------------------------------------------------------
            list += "<span class='type' style='background-color:"+e.color+";'>"+e.entryType;
            if (e.location.length+e.room.length>0)
            {
                list += "<span class='location'>";
                list += " ["+e.room;
                if (e.location.length>0 && e.room.length>0)
                    list += ", ";
                list += e.location+"]";
                list += "</span>"
            }
            list += "</span>";
                // -------------------------------------------------------


            // Sort all entries in a session by startDate/time
            var entries = [];
            for (var entry in e.entries)
                entries.push([ e.entries[entry].startDate.time, e.entries[entry]]);
            entries.sort(function(a, b) { return a[0] > b[0]; });
            // description, title, material, url, entryType, presenters []

            for (var i=0; i<entries.length; i++)
            {
                var e = entries[i][1];

                // =======================================================
                list += "<div class='contribution'>";


                // -------------------------------------------------------
                list +=    "<span class='date'>"+e.startDate.time.substr(0,5)+" ";
                list +=       "<a class='title' href='"+e.url+"'>"+e.title+"</a>";
                list +=    "</span>";
                // -------------------------------------------------------


                // -------------------------------------------------------
                list += "<span class='presenters'>";
                var p = e.presenters;
                for (var j=0; j<p.length; j++)
                {
                    list += p[j].name;
                    if (p[j].affiliation.length>0)
                        list += " ["+p[j].affiliation+"]";
                    if (p[j].email.length>0)
                        list += " <a class='email' href='email:"+p[j].email+"'>"+p[j].email+"</a>";
                    list += "<br/>";
                }
                list +=    "</span>";
                // -------------------------------------------------------


                list +=    "<span class='description'>"+e.description+"</span>";


                // -------------------------------------------------------
                list +=    "<span class='material'>";
                var m = e.material;
                for (var j=0; j<m.length; j++)
                {
                    list += "<span class='title'>"+m[j].title+": </span>";

                    list += "<span class='resources'>";
                    var r = m[j].resources;
                    for (var k=0; k<r.length; k++)
                    {
                        list += "<a class='url' href='"+r[k].url+"'>"+r[k].name+"</a>";
                        if (r[k].description.length>0)
                            list += "<span class='description'>" + m[k].description + "</span>";
                    }
                    list += "</span>";

                    if (m[j].description.length>0)
                        list += "<span class='description'> ["+m[j].description+"]</span>";

                }
                list +=    "</span>"; // indico-contribution-material
                // -------------------------------------------------------


                list += "</div>"; // indico-contribution
                // =======================================================
            }

            list +=   "</div>";   // indico-session-body
            // =======================================================


            list += "</div>"; // collapsible "indico-session"

            /*

                "material": [
                {
                  "_type": "Slides",
                  "description": "",
                  "title": "Slides",
                  "_fossil": "materialMinimal",
                  "protectionURL": "https://indico.scc.kit.edu/indico/event/215/manage/session/3/contribution/28/material/?returnURL=",
                  "type": "",
                  "id": "slides",
                  "resources": [
                    {
                      "_type": "LocalFile",
                      "name": "Auger-HEAT.pdf",
                      "url": "https://indico.scc.kit.edu/indico/event/215/session/3/contribution/28/material/slides/0.pdf",
                      "_fossil": "localFileMinimal",
                      "protectionURL": "https://indico.scc.kit.edu/indico/event/215/manage/session/3/contribution/28/material/?returnURL=",
                      "description": ""
                    }*/

            // HERE WE NEED TO LOOP OVER THE CONTRIBUTIONS

            //alert(JSON.stringify(slots[s][1]));
            //break;

            // entryType "Session" "Contribution" "Break"
            // isPoster,
            // startDate { date, tz }
            // endDate   { date, tz }
            // duration
            // contribDuration,
            // color
            // textColor,
            // title
            // slotTitle
            // location
            // room,
            // conveners []
            // material []
            // entries { }
            // url,
            // pdf
            //
            // sessionSlotId
            // conferenceId
            // inheritRoom
            // uniqueid
            // _fossil "linedTimeSchEntry"
            // _type "LinkedTimeSchEntry"
            // sessionCode,
            // sessionid,
            // inheritLoc,
        }

        //list += "</div>"; // collapsible-set "day"
        list += "</div>"; // collapsible
    }

    $('#list').append(list);
    $('#list').collapsibleset('refresh');
}

function read(json)
{
    var ID = Object.keys(json.results);

    process(ID, json);

    $('#footer').css("position", "relative");
    $.mobile.loading('hide');
}

function onReady()
{
    $.mobile.loading('show', {
       text: "Loading timetable...",
       textVisible: true,
       /* theme: "a", */
    });

    /*---------------------------------------------------------------------------------------------
     Request the timetabel of the indico event we are interested in
     ----------------------------------------------------------------------------------------------*/

    var ID = window.location.href.split("?")[1];

    if (ID)
        ID = ID.split("&").find(function(str){ return str.split("=")[0]=="id"; });

    ID = !ID ? default_event : ID.split("=")[1];

    $.getJSON(indico_url+"/export/timetable/"+ID+".jsonp?callback=?");
}

$('document').ready(onReady);
