Mobile Indico
=============

Mobile Indico aims to display an indico event in a mobile friendly way.


Quick guide - direct access
===========================

If you are happy with the existuing layout, you can access an event
with a given id (example: 254) from a given indico server (example:
https://indico.scc.kit.edu/indico/) as a mobile version directly by

https://www.fact-project.org/svn/trunk/MobileIndico/indico.html?url=https://indico.scc.kit.edu/indico/&id=254

If you find that too long, you can use http://tinyurl.com to shorten
the link.

A short version of the core url is available as

http://tinyurl.com/MyIndico?url=https://indico.scc.kit.edu/indico/&id=254


Introduction
============

Mobile Indico is a simple web-page which converts an indico timetable
into a mobile webpage. The trick is to request the data through the
Indico Export API (https://indico.readthedocs.io/en/master/http_api/)
and display it in a mobile friendly way.

Therefore, the webpage requests the timetable (see 2.3.3) as JSON
object which is then formatted to HTML in a Javascript. To avoid that a
server is required (e.g. php script) which retrieves the JSON (to work
around restirctions on cross site scripting) the JSONP interface is
used.

The trick of JSONP is to wrap the JSON opject into a script (Javascript
function) and insert a <script> tag into the webpage. Thus the script
containing the data is loaded and the data can be processed.

The advantage now is that the client side browser will request the data
directly from the indico server.


Installation on your own server
===============================

First download all files from

https://trac.fact-project.org/browser/trunk/MobileIndico

and copy them to a webserver.

The current version is bound to a single indico server which is
specified in indico.js in the first line, as well as the number
of the default event if no event is specified:

var indico_url = "https://indico.scc.kit.edu/indico/";
var default_event = 215;

Adapt that according to your needs.


User access to indico.html
==========================

The default timetable is then accessed through

http://you.web-server.com/your-path/indico.html

and another event (e.g. 215) through

http://you.web-server.com/your-path/indico.html?id=215

A debug mode in which the received JSON object is displayed is
available as well

http://you.web-server.com/your-path/indico.html?id=215&debug

It is also possible to overwrite the default indico url, for exmaple

http://you.web-server.com/your-path/indico.html?url=https://indico.scc.kit.edu/indico/&id=215


Files
=====

indico.css:  A simple style sheet to format the output
indico.svg:  The indico logo at the header line
rwth.avg:    The rwth logo at the footer
indico.js:   The javascript retrieving the data and formatting the html
indico.html: The main html page for user access


Style sheet
===========

For formatting purpose, the data is wrapped in classes like this:

<indico>
   Date
   <session>
      <date>
         Time
      </date>
      <body>
         <type>
            entryType
            <location>
               Location
            </location>
         </type>
         <contribution>
            <date>
               Time
               <title>
                  Title
               </title>
            </date>
            <presenters>
               Name Affiliation Email
            </presenters>
            <presenters>
               ...
	    </presenters>
            ...
            <description>
               Description
            </description>
            <material>
               <title>
                  Title
               </title>
               <resources>
                  <url>
                     URL
                  </url>
                  <description>
                     Description
                  </description>
                  ...
               </resources>
               <description>
                   Description
               </description>
            </material>
            <material>
               ...
            </material>
            ...
         </contribution>
         <contribution>
            ...
         </contribution>
         ....
      </body>
   </session>
   <session>
      ...
   </session>
    ...
</indico>
