#!/bin/bash
#
# This script does a backup of the QLA results
# It can be used in different location
# 
# Be careful: do NOT use --delete as on daq callisto files are deleted
# 

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

set -C

# get paths depending on host
case $HOSTNAME in
         daq) from=( "/loc_data/analysis/" )
              to=( "/newdaq/analysis_bu" )
              ## new temporary solution with rsync-servers
              #to="newdaq::newdaq/analysis_bu"
              ;;
   isdc-dl00) from=( "fact@161.72.93.131:/daq/analysis/" "/gpfs0/fact/processing/qla/" )
              #to="/gpfs/scratch/fact/qla"
              to=( "/gpfs0/fact/processing/qla"  "operator@coma.astro.uni-wuerzburg.de:/fact/data/qla")
              # for new rsync: update variables
              ;;
           *) echo "no valid host "$HOSTNAME
              exit
              ;;
esac

logfile=$runlogpath"/BackupQLA-"$datetime".log"
date >> $logfile

for (( i=0 ; i < ${#from[@]} ; i++ ))
do 
   printprocesslog "INFO rsync "${from[$i]}" to "${to[$i]}
   echo "rsync from "${from[$i]}" to "${to[$i]} >> $logfile 2>&1
   if ! rsync -auv ${from[$i]} ${to[$i]} >> $logfile 2>&1
   then
      printprocesslog "CONNECTION problem rsyncing QLA from "${from[$i]}" to "${to[$i]}
      echo `date`": problem rsyncing QLA from "${from[$i]}" to "${to[$i]} >> $logfile 2>&1
   fi
done

finish >> $logfile 2>&1

