#ifndef MARS_MHRanForestGini
#define MARS_MHRanForestGini

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TArrayF
#include <TArrayF.h>
#endif

class TH1D;
class TGraph;
class MParList;
class MRanForest;
class MRanTree;

class MHRanForestGini : public MH
{
private:
    MRanForest *fRanForest;

    TArrayF fGini;
    TGraph *fGraphGini;

public:
    MHRanForestGini(Int_t nbins=100, const char *name=NULL, const char *title=NULL);
    ~MHRanForestGini();

    TGraph *GetGraphGini() const  { return fGraphGini; }

    Bool_t SetupFill(const MParList *plist);
    Bool_t Fill(const MParContainer *par);
    Bool_t Finalize();

    void Draw(Option_t *opt="");
    TObject *DrawClone(Option_t *opt="") const;

    ClassDef(MHRanForestGini, 1)
};

#endif