#!/bin/bash
#

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"

# binning
bin=20

# get date
# add funtion
night=20160102

# get sources for current night from DB (RunInfo)
sourcekey=1

# get limits from DB
siglimit=3.0
exclimit=20

# query to get excess rate and significance from DB
query="SELECT o.* FROM"
query=$query" (SELECT fRunID, IF (@os+fOnTimeAfterCuts/60.>"$bin", @sig := fNumSigEvts, @sig := @sig + fNumSigEvts) AS sigevts, "
query=$query" IF (@os+fOnTimeAfterCuts/60.>"$bin", @bg := fNumBgEvts, @bg := @bg + fNumBgEvts) AS bgevts,  "
query=$query" IF (@os+fOnTimeAfterCuts/60.>"$bin", @exc := fNumExcEvts, @exc := @exc + fNumExcEvts) AS excevts, "
query=$query" IF (@os+fOnTimeAfterCuts/60.>"$bin", @os := fOnTimeAfterCuts/60., @os := @os + fOnTimeAfterCuts/60.) AS ontime, "
query=$query" @exc/@os*60 AS excrate, "
query=$query" IF (@sig>0 AND @bg*5>0 AND (@sig*Log(@sig/(@sig+@bg*5)*1.2/0.2)+@bg*5*Log(@bg*5/(@sig+@bg*5)*1.2))> 0, Sqrt((@sig*Log(@sig/(@sig+@bg*5)*1.2/0.2)+@bg*5*Log(@bg*5/(@sig+@bg*5)*1.2))*2), 0) AS sig "
query=$query" FROM AnalysisResultsRunLP O LEFT JOIN RunInfo USING (fNight, fRunID) "
query=$query" CROSS JOIN (SELECT @os :=0, @sig :=0, @bg := 0, @exc :=0, @rate :=0) PARAMS "
query=$query" WHERE fNight="$night" AND fSourceKey="$sourcekey") o HAVING ontime > "$bin"*0.9"

echo $query 

exit 

results=( `sendquery` )
#echo ${results[@]}

i=0
while [ 0 -lt 1 ]
do 
   num=`echo "$i * 7" | bc -l`
   if [ "${results[$num]}" = "" ]
   then 
      break
   fi
   runid=${results[$num]}
   sig=${results[$num+6]}
   exc=${results[$num+5]}
   
   trigger=`echo " $exc > $exclimit && $sig > $siglimit " | bc -l`
   
#   echo $i" "$num" "$exc" "$sig
   if [ $trigger -eq 1 ]
   then
      # do whatever to be done to trigger
      #  - send email/sms / call
      #  - create amon file
      #  - prepare email for alert
      echo $runid" "$exc" "$sig" -> "$trigger
      triggerfile="/home/fact/flare.alerts/"$night"_"$runid"_"$sourcekey".trigger"
      touch $triggerfile
   fi
   # counter
   i=`echo $i +1 | bc -l`
done

finish 


# store limits in DB? -> Source table
# run for current night
# run for each source in the current night
# error emails in case no DB content / no QLA
# email in case of flare
# add further information
#  obstime (start, stop, duration), mjd, zd-range, light-condition/threshold-range, weather, (check template)
# binning as command-line-option or loop for different binnings
# create VO-Event file
# create template-email
# add logging
# add certaindate
# implement option for archival testing

# calculate delay of QLA and send email if > 30 Min

# queries: 
# http://stackoverflow.com/questions/32247263/mysql-select-last-n-rows-while-sum-less-then-number
# http://stackoverflow.com/questions/14890486/limiting-the-rows-to-where-the-sum-a-column-equals-a-certain-value-in-mysql



