/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 <mailto:tbretz@astro.uni-wuerzburg.de>
!
!   Copyright: MAGIC Software Development, 2000-2002
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MRead                                                                   //
//                                                                         //
// Base class for all reading tasks                                        //
//                                                                         //
// You can set a selector. Depending on the impelementation in the derived //
// class it can be used to skip events, if the filter return kFALSE.       //
// Make sure that the selector (filter) doesn't need information which     //
// doesn't exist before reading an event!                                  //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MRead.h"

ClassImp(MRead);

// --------------------------------------------------------------------------
//
// Read the setup from a TEnv:
//   File0, File1, File2, ..., File10, ..., File100, ...
//
// Searching stops if the first key isn't found in the TEnv
//
// Enclosing quotation marks (") are removed
//
// Number of entries at the moment not supported
//
Bool_t MRead::ReadEnv(const TEnv &env, TString prefix, Bool_t print)
{
    //
    // Don't allow 'global' setup of files
    //
    if (prefix.IsNull())
        return kFALSE;

    //
    // Search (beginning with 0) all keys
    //
    for (int i=0;; i++)
    {
        TString idx = "File";
        idx += i;

        // Output if print set to kTRUE
        IsEnvDefined(env, prefix, idx, print);

        // Try to get the file name
        TString name = GetEnvValue(env, prefix, idx, "");
        if (name.IsNull())
            return kTRUE;

        if (name.BeginsWith("\"") && name.EndsWith("\""))
        {
            name.Remove(name.Last('\"'), 1);
            name.Remove(name.First('\"'), 1);
        }

        AddFile(name);
    }

    return kTRUE;
}
