#ifndef MARS_MSelStandard
#define MARS_MSelStandard

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelStandard                                                            //
//                                                                         //
// Task to evaluate standard cuts                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;

class MSelStandard : public MTask
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fCut[5];
    TString      fHilName;
    TString      fHilSrcName; 

    Float_t     fUsedPixelsMax;
    Float_t     fCorePixelsMin;
    Float_t     fSizeMin;
    Float_t     fDistMin;
    Float_t     fDistMax;
    Float_t     fLengthMin;
    Float_t     fWidthMin;

public:
    MSelStandard(const char *HilName="MHillas", const char *HilSrcName="MHillasSrc",
                 const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SetCuts(Float_t usedpixelsmax, Float_t corepixelsmin,
                 Float_t sizemin, Float_t distmin, Float_t distmax,
                 Float_t lengthmin, Float_t widthmin)
      { fUsedPixelsMax = usedpixelsmax; fCorePixelsMin = corepixelsmin;
        fSizeMin = sizemin; fDistMin = distmin; fDistMax = distmax;
        fLengthMin = lengthmin; fWidthMin = widthmin; } 

    ClassDef(MSelStandard, 0)   // Task to evaluate standard cuts
};

#endif











