#ifndef MARS_MPointingCorr
#define MARS_MPointingCorr

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPointingCorr                                                           //
//                                                                         //
// Task to do the pointing correction                                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcEvt;
class MSrcPosCam;
class MParameterD;


class MPointingCorr : public MTask
{
private:
    MMcEvt       *fMcEvt;       
    MSrcPosCam   *fSrcPos;
    TString       fSrcName;
    MParameterD  *fHourAngle;

    Float_t      fMm2Deg;

public:
    MPointingCorr(const char *name=NULL, const char *title=NULL,
                  const char *srcname="MSrcPosCam");

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MPointingCorr, 0)   // Task to do the pointing correction
};

#endif











