#!/bin/bash

sqlpw=/home/$USER/.mysql.pw.op
dbname=factdata

# reference values for corrected R750
rates=(  0.0 # 0
         0.0 # 1
         0.0 # 2
         0.0 # 3
         0.0 # 4
         0.0 # 5
         0.0 # 6
       267.1 # 7
       267.1 # 8
       271.8 # 9
       295.0 #10
       257.3 #11
       248.6 #12
       237.1 #13
       244.0 #14
       241.0 #15
       263.8 #16
       245.4 #17
       254.3 #18
       263.3 #19
       278.1 #20
       267.1 #21
       234.9 #22
       259.9 #23
       268.8 #24
       281.6 #25
       272.1 #26
       269.5 #27
       266.6 #28
         0.0 #29
       246.5 #30
       246.5 #31
       286.9 #32
       289.4 #33
       278.7 #34
       266.3 #35
       258.4 #36
       273.8 #37
       276.3 #38
       275.4 #39
       279.9 #40
       286.2 #41
       289.1 #42
       276.4 #43
       279.3 #44
       271.8 #45
       252.9 #46b
       254.3 #47
       252.0 #48
       255.4 #49
       265.3 #50
       263.8 #51
       261.3 #52
       253.9 #53
       242.5 #54
       242.6 #55
       241.5 #56
       248.7 #57
       248.7 #58
       243.4 #59
       249.3 #60b
       248.4 #61
       261.3 #62
       257.6 #63
       244.3 #64
       248.2 #65
       241.6 #66
       234.8 #67
       234.1 #68
       291.2 #69
       248.8 #70
       233.1 #71
       242.0 #72
       226.2 #73
       215.1 #74
       244.6 #75
       246.7 #76
       249.9 #77
         0.0 #78
       )

for (( i=0; i < ${#rates[@]} ; i++)) 
do
   if [ "${rates[$i]}" = "0.0" ]
   then 
      rate="NULL"
   else
      rate=${rates[$i]}
   fi
   query="UPDATE RunInfo SET fR750Ref="$rate" WHERE fPeriod="$i
   echo $query
   mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 
done

# periods 42 and 60 are split: 
# 60a
query="UPDATE RunInfo SET fR750Ref=243.4 WHERE fPeriod=60 AND fNight<20170901"
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 
# 46a
query="UPDATE RunInfo SET fR750Ref=275 WHERE fPeriod=46 AND fNight<20150716"
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 


# fill corrected R750
query="UPDATE RunInfo SET "
query=$query" fR750Cor=round(fNumThreshold750/(TIME_TO_SEC(TIMEDIFF(fRunStop,fRunStart))*fEffectiveOn/60)/pow(1/cos(fZenithDistanceMean/180*Pi())*exp(1-1/cos(fZenithDistanceMean/180*Pi())), 1.22),2) "
query=$query" WHERE fRunTypeKey=1 AND NOT ((TIME_TO_SEC(TIMEDIFF(fRunStop,fRunStart))*fEffectiveOn/60)/pow(1/cos(fZenithDistanceMean/180*Pi())*exp(1-1/cos(fZenithDistanceMean/180*Pi())), 1.22))=0"
echo $query
mysql --defaults-file=$sqlpw -u operator -h 10.0.100.21 $dbname -s -e "$query" 

