void magicweather(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    Float_t temp, hum, pres, dew, wind, gust;
    file.SetPtrAddress("Time",  &time);
    file.SetPtrAddress("T",     &temp);
    file.SetPtrAddress("H",     &hum);
    file.SetPtrAddress("P",     &pres);
    file.SetPtrAddress("T_dew", &dew);
    file.SetPtrAddress("v",     &wind);
    file.SetPtrAddress("v_max", &gust);

    UInt_t offset = file.GetUInt("MJDREF");
    //cout << "offset: " << offset << endl;
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    int    cnt  = 0;
    double avg_t  = 0;
    double rms_t  = 0;
    double avg_h  = 0;
    double rms_h  = 0;
    double avg_p  = 0;
    double rms_p  = 0;
    double avg_d  = 0;
    double rms_d  = 0;
    double avg_w  = 0;
    double rms_w  = 0;
    double avg_g  = 0;
    double rms_g  = 0;

    double last_t = -1;
    double last_h = -1;
    double last_p = -1;
    double last_d = -1;
    double last_w = -1;
    double last_g = -1;
    double diff = -1;
    double diff2 = -1;

    while (file.GetNextRow())
    {
        time += offset;
        //cout << time << " " << temp << endl;

        if  (time>end)
        {
            diff2 = time-end;
            if (diff2<diff)
            {
                last_t = temp;
                last_h = hum;
                last_p = pres;
                last_d = dew;
                last_w = wind;
                last_g = gust;
                diff=diff2;
            }
            break;
        }

        if (time<beg)
        {
            last_t = temp;
            last_h = hum;
            last_p = pres;
            last_d = dew;
            last_w = wind;
            last_g = gust;
            diff = beg-time;
            continue;
        }

        avg_t += temp;
        rms_t += temp*temp;
        avg_h += hum;
        rms_h += hum*hum;
        avg_p += pres;
        rms_p += pres*pres;
        avg_d += dew;
        rms_d += dew*dew;
        avg_w += wind;
        rms_w += wind*wind;
        avg_g += gust;
        rms_g += gust*gust;
        cnt ++;
    }

    if (cnt==0)
    {
        if (diff>5./24/3600)
            return;

        //only give output if values within 5 min before/after are available
        cout << "result " << last_t << " 0 "  << last_h << " 0 "
            << last_p << " 0 "  << last_d << " 0 "
            << last_w << " 0 "  << last_g << " 0 " << endl;
        return;
    }

    avg_t /= cnt;
    rms_t /= cnt;
    avg_h /= cnt;
    rms_h /= cnt;
    avg_p /= cnt;
    rms_p /= cnt;
    avg_d /= cnt;
    rms_d /= cnt;
    avg_w /= cnt;
    rms_w /= cnt;
    avg_g /= cnt;
    rms_g /= cnt;

    rms_t = sqrt(rms_t-avg_t*avg_t);
    rms_h = sqrt(rms_h-avg_h*avg_h);
    rms_p = sqrt(rms_p-avg_p*avg_p);
    rms_d = sqrt(rms_d-avg_d*avg_d);
    rms_w = sqrt(rms_w-avg_w*avg_w);
    rms_g = sqrt(rms_g-avg_g*avg_g);

    cout << "result " << avg_t << " " << rms_t << " "  << avg_h << " " << rms_h << " "
        << avg_p << " " << rms_p << " "  << avg_d << " " << rms_d << " "
        << avg_w << " " << rms_w << " "  << avg_g << " " << rms_g << " " << endl;
}
