#!/bin/bash


path=/fact/aux/2017
files=`grep Torque $path/*/*/*.log | cut -d: -f1 | sort | uniq`

deltat="30./3600."
echo "Using "$deltat" hours."

for file in $files
do
   dir=`dirname $file`
   date=`basename $file | cut -d. -f1`
   echo "Night: "$date
   y=`dirname $file | cut -d/ -f4`
   m=`dirname $file | cut -d/ -f5`
   d=`dirname $file | cut -d/ -f6`
   drivefile=$dir/$date.DRIVE_CONTROL_POINTING_POSITION.fits
   #echo $drivefile

   warning=`grep Torque $file | sed -e 's/\ //g' | grep -o -E "[012][0-9]:[0-5][0-9]:[0-5][0-9].[0-9]{3}000-DRIVE_CONTROL:IndraDrive[AZ][dz]" `
   #echo $warning
   for warning in $warning
   do
      timestamp=`echo $warning | grep -o -E [012][0-9]:[0-5][0-9]:[0-5][0-9].[0-9]{3}`
      indradrive=`echo $warning | grep -o -E [AZ][dz]`
      datetime=`date -d "$date $timestamp" +"%s"`
      #echo $datetime
      h=`echo $timestamp | cut -c 1-2`
      #echo $h
      if [ $h -lt 12 ]
      then 
         start=`echo " $datetime / 86400 + 1 - ($deltat/24.) " | bc -l`
         stop=`echo " $datetime / 86400 + 1 + ($deltat/24.) " | bc -l`
      else
         start=`echo " ( $datetime ) / 86400 - ($deltat/24.) " | bc -l`
         stop=`echo " ( $datetime ) / 86400 + ($deltat/24.) " | bc -l`
      fi
      #echo $start" "$stop
      stats=`/home/fact/FACT++/fitsdump -s -c Time -c Az -c Zd --filter="[1] > $start && [1] < $stop " $drivefile  2>/dev/null`
      #echo $stats
# trackingstats=`$factpath/fitsdump $trackingfile -s -c Time -c Ra -c Dec -c Zd -c Az --filter='[1]<'${tstop}' && [1]>'${tstart}  2>/dev/null`
      zd=`echo $stats | grep -E -o '\['Zd':0[:]?[0-9]*\]\ Min:\ [-]?[0-9]+[.]?[0-9]*\ Max:\ [-]?[0-9]+[.]?[0-9]*\ Med:\ [-]?[0-9]+[.]?[0-9]*\ Avg:\ [-]?[0-9]+[.]?[0-9]*\ Rms:\ [-]?[0-9]+[.]?[0-9]*[e]?[-]?[0-9]*'`
      az=`echo $stats | grep -E -o '\['Az':0[:]?[0-9]*\]\ Min:\ [-]?[0-9]+[.]?[0-9]*\ Max:\ [-]?[0-9]+[.]?[0-9]*\ Med:\ [-]?[0-9]+[.]?[0-9]*\ Avg:\ [-]?[0-9]+[.]?[0-9]*\ Rms:\ [-]?[0-9]+[.]?[0-9]*[e]?[-]?[0-9]*'`
      zdmin=`echo $zd | grep -E -o 'Min:\ [-]?[0-9]+[.]?[0-9]*' | sed -e 's/Min:\ //'`
      zdmin=`echo "scale=2 ; $zdmin / 1 " | bc -l`
      zdmax=`echo $zd | grep -E -o 'Max:\ [-]?[0-9]+[.]?[0-9]*' | sed -e 's/Max:\ //'`
      zdmax=`echo "scale=2 ; $zdmax / 1 " | bc -l`
      azmin=`echo $az | grep -E -o 'Min:\ [-]?[0-9]+[.]?[0-9]*' | sed -e 's/Min:\ //'`
      azmin=`echo "scale=2 ; $azmin / 1 " | bc -l`
      azmax=`echo $az | grep -E -o 'Max:\ [-]?[0-9]+[.]?[0-9]*' | sed -e 's/Max:\ //'`
      azmax=`echo "scale=2 ; $azmax / 1 " | bc -l`
      echo " Torque-Warning "$indradrive" @ "$timestamp" zd: "$zdmin" "$zdmax" az: "$azmin" "$azmax
      #echo "---"
   done

#exit
   #/home/fact/FACT++/fitsdump -c Time -c Az -c Zd --limit=1 $drivefile
done

#./fitsdump -c Time -c Az -c Zd --filter="[1] > 17519.14583 && [1] < 17519.14652 " /fact/aux/2017/12/18/20171218.DRIVE_CONTROL_POINTING_POSITION.fits

exit

drivefile=/fact/aux/2017/12/15/20171215.DRIVE_CONTROL_POINTING_POSITION.fits
start=17516.28780092592592592593
stop=17516.28918981481481481481
/home/fact/FACT++/fitsdump  -s -c Time -c Az -c Zd --filter="[1] > $start && [1] < $stop " $drivefile 2>/dev/null 

exit

