#ifndef MARS_MFCT1SelBasic
#define MARS_MFCT1SelBasic

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFCT1SelBasic                                                           //
//                                                                         //
// Class to evaluate basic cuts                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MGeomCam;
class MPedestalCam;
class MCerPhotEvt;
class MHillas;
class MMcEvt;
class MRawRunHeader;

class MFCT1SelBasic : public MFilter
{
private:
    const MPedestalCam  *fPed;      // Pedestal information
    const MGeomCam      *fCam;      // Camera Geometry 
    const MCerPhotEvt   *fEvt;      // Cerenkov Photon Event 
    const MMcEvt        *fMcEvt;       
    const MRawRunHeader *fRawRun;       

    Float_t     fMinPhotons;
    Float_t     fThetaMin;
    Float_t     fThetaMax;

    Bool_t      fResult;

    Int_t       fCut[4];

public:
    MFCT1SelBasic(const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    Bool_t SwTrigger();
    void SetCuts(Float_t minphotons, Float_t thetamin, Float_t thetamax);

    ClassDef(MFCT1SelBasic, 0)   // Class to evaluate basic cuts
};

#endif











