#ifndef MARS_MCT1SupercutsCalc
#define MARS_MCT1SupercutsCalc

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MCT1SupercutsCalc                                                       //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MCerPhotEvt;
class MGeomCam;
class MHadronness;


class MCT1SupercutsCalc : public MTask
{
private:
    MHillas     *fHil;
    MHillasSrc  *fHilSrc;
    MMcEvt      *fMcEvt;
    MGeomCam    *fCam;   
    MHadronness *fHadronness;     //! output container for hadronness

    TString     fHadronnessName;  // name of container to store hadronness
    TString     fHilName;
    TString     fHilSrcName;

    Double_t    fMm2Deg;


    //---------------------------------
    // cut parameters
       
    double lengthup[8];
    double widthup[8];
    double distup[8];
    double lengthlow[8];
    double widthlow[8];
    double distlow[8];
    double asymup[8];
    double asymlow[8];
    double alphaup[8];
    //---------------------------------


public:
    MCT1SupercutsCalc(const char *hilname="MHillas", 
                       const char *hilsrcname="MHillasSrc",
                       const char *name=NULL, const char *title=NULL);
    ~MCT1SupercutsCalc();

    Double_t CtsMCut(Double_t *a, Double_t ls, Double_t ct, 
                     Double_t ls2, Double_t dd2);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    TString GetHadronnessName() const { return fHadronnessName; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MCT1SupercutsCalc, 1) // A class to evaluate the Supercuts
};

#endif





