#ifndef MARS_MHMcTriggerLvl2
#define MARS_MHMcTriggerLvl2

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class TF1;
class MMcTriggerLvl2;

class MHMcTriggerLvl2 : public MH
{
 public:
 

private:

    TH1F *hfLutPseudoSize;        // Histogram of fLutPseudoSize
    TH1F *hfLutPseudoSizeNorm;    // Histogram of fLutPseudoSize normalized on integral of distribution
    TH1F *hfPseudoSize;           // Histogram of fPseudoSize
    TH1F *hfPseudoSizeNorm;       // Histogram of fPseudoSize normalized on integral of distribution
    TH1F *hfSizeBiggerCell;       // Histogram of fSizeBiggerCell
    TH1F *hfSizeBiggerCellNorm;   // Histogram of fSizeBiggerCell normalized on integral of distribution

    TF1* f1;                      // Function used to normalize histograms
    
public:
    MHMcTriggerLvl2(const char *name=NULL, const char *title=NULL);
    ~MHMcTriggerLvl2();

    Bool_t Fill(const MParContainer *par);

    TH1 *GetHistByName(const TString name);

    TH1F *GetHistfLutPseudoSize() const { return hfLutPseudoSize; }
    TH1F *GetHistfLutPseudoSizeNorm() const { return hfLutPseudoSizeNorm; }
    TH1F *GetHistfPseudoSize()  const { return hfPseudoSize; }
    TH1F *GetHistfPseudoSizeNorm()  const { return hfPseudoSizeNorm; }
    TH1F *GetHistfSizeBiggerCell()  const { return hfSizeBiggerCell; }
    TH1F *GetHistfSizeBiggerCellNorm()  const { return hfSizeBiggerCellNorm; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    TH1 *NormalizeHist(TH1 *histNorm, TH1 *hist) const;

    ClassDef(MHMcTriggerLvl2, 1) // Container which holds histograms for the Trigger Level2 image parameters

private:

    TObject *DrawHist(TH1 *hist, TH1 *histNorm, const char *canvasname, Int_t *colore) const;

};


#endif
