#!/bin/bash
#
# Script to copy scheduling plots and suggested schedule to the web 
#

# remarks:
#
# be aware that the script only writes files which don't exist yet
# i.e. in case of a new sw version, old files have to be deleted or moved away
# you can also delete only the txt-files with the suggested schedule
#
# script to be executed on gate, i.e. FACT++ there has to be up-to-date

# create plots for past (-) / future (+) night
directions=( "-" "+" )

# number of days to be treated
numdays=731
#numdays=7

schedulefile=/home/dorner/FACT-Schedule-for-XMM.txt
mrk421file=/home/dorner/FACT-Schedule-Mrk421.txt
mrk501file=/home/dorner/FACT-Schedule-Mrk501.txt
mrk1959file=/home/dorner/FACT-Schedule-1959.txt

#exit

# filling file
echo "# FACT Schedule from 2019-01-01 till 2020-12-31" > $schedulefile

# creating files for $numdays days (if they don't exist yet)
for (( i=0; i < $numdays ; i++))
do 
   date=`date --date="20190101+${i}days" +%Y-%m-%d`
   date2=`date --date="20190101+${i}days" +%Y%m%d`
   echo $date
   #num=`~/SW/FACT++.2019.01.01/build/makeschedule $date 2>/dev/null | tail -9 | grep ^201 | grep -c SHUTDOWN`
   ~/SW/FACT++.2019.01.01/build/makeschedule $date 2>/dev/null | sed -e '1,/SHUTDOWN/d' | grep ^20[12][0-9] >> $schedulefile
   #echo ""
done

text=`cat $schedulefile`
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] Mrk 421 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk421file
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] Mrk 501 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk501file
echo $text | grep -E -o "20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9] 1ES 1959\+650 \[[0-9]{2,3}'; [0-9]{1,2}.[0-9]\/[0-9]{1,2}.[0-9]\] 20[12][0-9]-[0-2][0-9]-[0-3][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]" | awk ' { print $1 " " $2 " - " $7 " " $8 " " $5 } ' | sed -e 's/;/]/' > $mrk1959file

