#!/bin/bash

source `dirname $0`/../Sourcefile.sh
printprocesslog "INFO starting $0"



# for refilling DB from scratch several processes are useful
# therefore two commandline options have been implemented: 
#   numjobs: number of process that are started from FillAnalysisResults.sh
#   numjob: number of the current process [0 to numjobs-1]
if [ "$2" != "" ]
then
   numjobs=$2
   if [ "$3" == "" ]
   then
      echo "missing third argument (numjob)"
      finish
   else
      numjob=$3
   fi
   if [ $3 -gt $(($2 - 1)) ]
   then
      echo "you cannot start a job with a number larger than the number of jobs you specified"
      finish
   fi
else
   numjobs=1
   numjob=0
fi 



# to run this script for different analyses, a command line 
#   option has been implemented: 
# analysis: name of the analysis
if [ "$1" != "" ]
then
   analysis=$1
else
   echo "You have to give the name of the analysis that you want to fill into the DB."
   echo "  Currently available: CutsLC"
   finish
fi

# setup for script
program="Analysis"$analysis
step="Analysis"$analysis
# setup for mysql DB
sql=`dirname $0`"/../Setup/get_results_"$analysis".sql"
resulttable="AnalysisResultsRun"$analysis

# setup for rootifysql
prog="/swdev_nfs/FACT++.r19193-bin/rootifysql"
config="--config="`dirname $0`"/../Setup/rootifysql.eth.rc"



set -C

# check if script is already running
lockfile=$lockpath/lock-$numjob-$program.txt
checklock 

logfile=$runlogpath"/FillAnalysisResults"$analysis"-"$numjob"-"$datetime".log"
date >> $logfile

# get todo list
gettodo 

for (( s=0 ; s < $num ; s++ ))
do
   night=${primaries[$s+$s]}
   runid=${primaries[$s+$s+1]}
   #fileid=fileid=`echo $night | cut -c 3-8``printf %03d $runid`
   
   if [ $(($runid % $numjobs)) -ne $numjob ]
   then
      printprocesslog "INFO processing only part of the data (runid "$runid", numjobs "$numjobs", "$numjob") -> continue"
      continue
   fi
   
   setstatus "start" 
   if [ $numchanged -eq 0 ]
   then
      printprocesslog "INFO "$numchanged" rows were changed in DB => "$night"_"$runid" is already processed => continue."
      continue
   fi

   # get file-id 
   query="SELECT FileID FROM CalcSourceStatus WHERE fNight="$night" AND fRunID="$runid
   fileid=`sendquery`
   #echo "INFO calculating source position for "$fileid
   printprocesslog "INFO calculating filling results ("$analysis") for "$fileid
   echo "INFO filling results ("$analysis") for "$fileid >> $logfile
   echo "INFO filling results ("$analysis") for "$fileid #>> $logfile

   outpath=$datapath/analysis_CutsLC/`echo $night | cut -c 1-4`/`echo $night | cut -c 5-6`/`echo $night | cut -c 7-8`
   makedir $outpath >> $logfile
   txt=$outpath/$fileid.txt
   log=$outpath/$fileid.log
   
   # run rootfiysql
   printprocesslog "DEBUG $prog $config $sql --delimiter , -w $txt --var.fileid=$fileid > $log 2>&1"
   $prog $config $sql --delimiter , -w $txt --var.fileid=$fileid -n >| $log 2>&1
   check1=$?
 
   
   case $check1 in
      0)   printprocesslog "INFO successfully got analysis results ("$analysis") for "$fileid
           vals=`cat $txt | grep -v '#'`
           query="REPLACE INTO "$resulttable" (fNight, fRunID, fNumSigEvts, fNumBgEvts, fNumExcEvts) VALUES("$vals")"
           #mysql --defaults-file=/home/dorner/.mysql.pw.local -s -e "$query"
           sendquery >> $logfile
           # remark: in case this sendquery fails, the job appears as crashed
           ;;
      *)   printprocesslog "ERROR could not get analysis results ("$analysis") for "$fileid
           check=$check1
           ;;
   esac

   setstatus "stop" 

done

finish 


