#!/bin/bash


# TeVCAT
# list copied on May 27, 2019, from http://tevcat.uchicago.edu/
tevcat="TeVCAT.txt"
tevcatdim="TeVCAT.dim"

if ! [ -e $tevcatdim ]
then 
   sources=( `cat $tevcat | sort | grep -v '#' | cut -f1 | sed -e 's/\ /_/g'` )
   sources2=( `cat $tevcat | sort | grep -v '#' | cut -f2 | sed -e 's/\ /_/g'` )
   ras2=( `cat $tevcat | sort | grep -v '#' | cut -f3 | sed -e 's/\ /_/g'` )
   decs2=( `cat $tevcat | sort | grep -v '#' | cut -f4 | sed -e 's/\ /_/g'` )
   ras=( `cat $tevcat | sort | grep -v '#' | cut -f3 | sort | sed -e 's/\ /\ +\ /1' -e 's/\ /\ \/ 60\ +\ 1\/3600\ *\ /3' | bc -l` )
   decs=( `cat $tevcat | sort | grep -v '#' | cut -f4 | sed -e 's/\ /\ +\ /1' -e 's/\ /\ \/ 60\ +\ 1\/3600\ *\ /3' | sed -e 's/^/\(\ /m' -e 's/^(\ \-/-\ \(\ /m' -e 's/^(\ +/\(\ /m' -e 's/$/\ \)/m' | bc -l` )
   
   echo "#"`date` > $tevcatdim
   echo "#found sources "${#sources[@]}" in "$tevcat >> $tevcatdim

   #echo ${decs[@]}
   #exit

   for (( i=0 ; i<${#sources[@]} ; i++ ))
   do
     #echo $i" "${sources[$i]}" "${ras[$i]}
     source=`echo ${sources[$i]} | sed -e 's/_/\ /g'`
     source2=`echo ${sources2[$i]} | sed -e 's/_/\ /g'`
     #ra=`echo ${ras[$i]}' * 15 ' | bc -l`
     ra=${ras[$i]}
     dec=${decs[$i]}
     #echo $i" "$source" "$ra" "$dec
     #echo $i" "$source2" "$ra" "$dec
     echo "SCHEDULER/ADD_SOURCE "$ra" "$dec" "\"$source2\" >> $tevcatdim
     #dimctrl
   done
fi
echo ""
echo "go to /home/fact/operation/ , start dimctrl and execute $tevcatdim with .x"
echo ""
echo ""
echo ""

# 2FHL catalog (as used by HAWC for online monitor
# list downloaded from VizierR (first select catalog, then columns)
# remark: put # in all lines in header - else sources are associated wrongly
fhl="2FHL.txt"
fhldim="2FHL.dim"

if ! [ -e $fhldim ]
then 
   # source primary name (doesn not exist for all
   sources=( `cat $fhl | grep -v '#' | grep -v -E '^$' | cut -d'|' -f4 | sed -e 's/^\ /-/m' | sed -e 's/\ \{1,\}$//m' | sed -e 's/\ /_/g'` )
   # 2FHL source name
   sources2=( `cat $fhl | grep -v '#' | grep -v -E '^$' | cut -d'|' -f1 | sed -e 's/\ \{1,\}$//m' | sed -e 's/\ /_/g'` )
   ras=( `cat $fhl | grep -v '#' | grep -v -E '^$' | cut -d'|' -f2 ` )
   decs=( `cat $fhl | grep -v '#' | grep -v -E '^$' | cut -d'|' -f3 ` )
   
   echo "#"`date` > $fhldim
   echo "#found sources "${#sources[@]}" in "$fhl >> $fhldim

   #echo ${decs[@]}
   #exit

   for (( i=3 ; i<${#sources[@]} ; i++ ))
   do
     #echo $i" "${sources[$i]}" "${ras[$i]}
     source=`echo ${sources[$i]} | sed -e 's/_/\ /g'`
     source2="2FHL "`echo ${sources2[$i]} | sed -e 's/_/\ /g'`
     #ra=${ras[$i]}
     ra=`echo ${ras[$i]}' / 15 ' | bc -l`
     dec=${decs[$i]}
     #echo "_"$source"_ _"$source2"_ "$ra" "$dec
     echo "_"$source"_ _"$source2"_"
     if [ "$source" = "-" ]
     then 
        echo "SCHEDULER/ADD_SOURCE "$ra" "$dec" "\"$source2\" >> $fhldim
     else
        echo "SCHEDULER/ADD_SOURCE "$ra" "$dec" "\"$source\" >> $fhldim
     fi
   done
fi
echo ""
echo "go to /home/fact/operation/ , start dimctrl and execute $fhldim with .x"
echo ""
echo ""
echo ""
