#ifndef MARS_MStatusDisplay
#define MARS_MStatusDisplay

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_TGFrame
#include <TGFrame.h>
#endif

class MGList;

class TCanvas;

class TGTab;
class TGLabel;
class TGProgressBar;
class TGHProgressBar;

class MStatusDisplay : public TGTransientFrame
{
private:
    MGList         *fList;
    TGHProgressBar *fBar;
    TGTab          *fTab;
    TGLayoutHints  *fLayCanvas;


    TGLabel *fLine1;
    TGLabel *fLine2;

    void AddProgressBar();
    void AddTabs();
    void AddStatusLine1();
    void AddStatusLine2();

    TCanvas *GetCanvas(TGCompositeFrame *f);

    Bool_t ProcessMessage(Long_t msg, Long_t mp1, Long_t mp2);
    void   CloseWindow();

public:
     MStatusDisplay();
     virtual ~MStatusDisplay();

     TGProgressBar *GetBar() const { return (TGProgressBar*)fBar; }

     void SetStatusLine1(const char *txt);
     void SetStatusLine2(const char *txt);

     TCanvas &AddTab(const char *name);

     TCanvas *GetCanvas(int i);
     TCanvas *GetCanvas(const TString &name);

     ClassDef(MStatusDisplay, 0)   // Window for a status display
};

#endif


