<!DOCTYPE HTML>
<html>
<head>
    <link rel="stylesheet" type="text/css" href="checkstyle.css" />
    <style>
        .error {color: #FF0000;}
    </style>

    <script language="JavaScript" type="text/javascript">
        if (document.getElementById) {
        document.writeln('<style type="text/css"><!--')
        document.writeln('.texter {display:none} @media print {.texter {display:block;}}')
        document.writeln('//--></style>') }
        function openClose(theID) {
            if (document.getElementById(theID).style.display == "block") {
                document.getElementById(theID).style.display = "none"
            } else {
                document.getElementById(theID).style.display = "block" }
        }
    </script>
</head>
<body>

<?php

    echo "<hr size='2px' style='border-width:5px'>\n";
    echo "<h1>Flare Alerts</h1>\n";
    echo "<hr>\n";
    echo "<h2>Acknowledge Alerts</h2>\n";

    if (!empty($_GET["date"]))
    {
        $today=$_GET["date"];
    }
    else
    {
        if (date("H")>18)
            $today=date("Ymd", mktime(0,0,0,date("m"), date("d"), date("Y")));
        else
            $today=date("Ymd",strtotime(date("Y-m-d", mktime(0,0,0,date("m"), date("d"), date("Y")))." -1 day"));
    }
    if (!empty($_GET["date2"]))
    {
        $today2=$_GET["date2"];
    }
    else
    {
        $today2=date("Ymd", mktime(0,0,0,date("m"), date("d"), date("Y")));
    }
    if (!empty($_GET["trigger"]))
        $trigger=$_GET["trigger"];
    else
        $trigger="New";
    if (!empty($_GET["type"]))
        $type=$_GET["type"];
    else
        $type=0;
    $year=substr($today,0,4);
    $month=substr($today,4,2);
    $day=substr($today,6,2);

    echo "<form method=\"post\" action=\"acknowledge_alerts.php\"  enctype=\"multipart/form-data\" >\n";
    //echo "<form method=\"get\" action=\"acknowledge_alerts.php\"  enctype=\"multipart/form-data\" >\n";
    echo "<p>\n";
    echo "User Name:    <input type='text' name='Uname' maxlength='50' /> <br>\n";
    echo "Password:     <input type='password' name='Passwd' maxlength='50' /> <br>\n";
    echo "</p>\n";
    //echo "<input type='text' name='link' value='test'\>\n";
    echo "<input type='submit' name='submit' value='Acknowledge Alerts' />\n";
    echo "<input type='hidden' name='link' value='".$_SERVER[REQUEST_URI]."'\>\n";
    //echo "---".$_SERVER[REQUEST_URI]."---";
    echo "</form>\n";
    echo "<hr>\n";

    echo "<h2>Display Alerts</h2>\n";
    echo "<form method=\"get\" action=\"index.php\"  enctype=\"multipart/form-data\" >\n";
    echo "<p>\n";
    echo "Date/Start:   <input type='text' name='date' size='8' maxlength='8' value='".$today."'/>\n";
    echo "Stop:    <input type='text' name='date2' size='8' maxlength='8' value='".$today2."'/> <br>\n";
    echo "Trigger:\n";
    if ($trigger=="All")
    {
        echo "<input type='radio' name='trigger' id='All' value='All' checked='checked'/> <label for='All'>all</label>\n";
        echo "<input type='radio' name='trigger' id='New' value='New' /> <label for='New'>new</label>\n";
    }
    else
    {
        echo "<input type='radio' name='trigger' id='All' value='All' /> <label for='All'>all</label>\n";
        echo "<input type='radio' name='trigger' id='New' value='New' checked='checked'/> <label for='New'>new</label>\n";
    }
    echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Type:    <input type='text' name='type' size='2' maxlength='2' value='".$type."'/> <br>\n";
    echo "</p>\n";
    echo "<input type='submit' name='submit' value='Show Alerts' />\n";
    echo "<input class='Width' type='button' value='Reset' onClick='self.location.href=\"index.php\"'>";
    echo "</form>\n";
    echo "<hr>\n";


    echo "<h2>".$trigger." alert(s) from ".$today." to ".$today2.": </h2>";
    if($_SERVER["HTTPS"] != "on")
    {
        header("Location: https://" . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"]);
        exit();
    }
    include('/home/fact/php_credentials/factweb.php');

    $db = new PDO(
            'mysql:host='.$host.';dbname=FlareAlerts;charset=utf8mb4',
            $user,
            $pass);

    // table with alert from table FlareAlerts.FlareTriggers
    echo "<table border='1' style='border-collapse:collapse'>\n";
    $first_row = 0;
    $colnames = "";

    $query="SELECT fSourceName AS 'Source', fTriggerKey AS 'Trigger', fTriggerType as 'Type', fRunID as 'Run', fBinning as 'Binning', ";
    $query.="fTriggerInserted as 'Inserted', fTriggerAcknowledged as 'Acknowledged', ";
    //$query.="CONCAT('<a target=\"_blank\" href=\"http://fact-project.org/monitoring/index.php?y=".substr($today,0,4)."&m=".substr($today,4,2)."&d=".substr($today,6,2)."&source=', fSourceKey, '&timebin=3&plot=night\">20Min</a> ', ";
    //$query.="'<a target=\"_blank\" href=\"http://fact-project.org/monitoring/index.php?y=".substr($today,0,4)."&m=".substr($today,4,2)."&d=".substr($today,6,2)."&source=', fSourceKey, '&timebin=12&plot=night\">Nightly</a>') as 'QLA', ";
    $query.="CONCAT('<a target=\"_blank\" href=\"http://www.fact-project.org/run_db/db/fact_runinfo.php?fSourceKEY=', fSourceKey, '&fStartDate=', "
        .$today.", '&fStopDate=', ".$today
        .", '&fSourceName=On&fRunTypeName=On&fRunStart=On&fRunStop=On&fZenithDistanceMean=On&fAzimuthMean=On&fTriggerRateMedian=On&fThresholdMedian=On&fSourceName=On\">RunInfo</a>') as 'RunInfo', ";
    $query.="CONCAT('<a target=\"_blank\" href=\"http://www.fact-project.org/run_db/db/fact_runinfo.php?fSourceKEY=', fSourceKey, '&fStartDate=', "
        .$today.", '&fStopDate=', ".$today.", '&fSourceName=On&fRunTypeKEY=-1\">Summary</a>') AS 'Summary', ";
    $query.="CONCAT('<image src=\"https://fact-project.org/lightcurves/".$year."/".$month."/".$day."/lightcurve', fSourceKey, '_20min_".$today.".root-2.png\" width=\"200\" height=\"200\"></image>\n <br>\n "
        ."<a target=\"_blank\" href=\"http://fact-project.org/monitoring/index.php?y=".substr($today,0,4)."&m=".substr($today,4,2)."&d=".substr($today,6,2)."&source=', fSourceKey, '&timebin=3&plot=night\">more details</a>\n') AS 'QLA 20min', ";
    $query.="CONCAT('<image src=\"https://fact-project.org/lightcurves/".$year."/".$month."/".$day."/lightcurve', fSourceKey, '_1night_".$today.".root-2.png\" width=\"200\" height=\"200\"></image>\n <br>\n "
        ."<a target=\"_blank\" href=\"http://fact-project.org/monitoring/index.php?y=".substr($today,0,4)."&m=".substr($today,4,2)."&d=".substr($today,6,2)."&source=', fSourceKey, '&timebin=12&plot=night\">more details</a>\n') AS 'QLA 1night', ";
    $query.="CONCAT('<image src=\"https://fact-project.org/lightcurves/".$year."/".$month."/".$day."/lightcurve', fSourceKey, '_1night_week.root-2.png\" width=\"200\" height=\"200\"></image>\n <br>\n "
        ."<a target=\"_blank\" href=\"http://fact-project.org/monitoring/index.php?y=".substr($today,0,4)."&m=".substr($today,4,2)."&d=".substr($today,6,2)."&source=', fSourceKey, '&timebin=12&plot=week\">more details</a>\n') AS 'QLA nightly last week' ";
    $query.="FROM FlareTriggers LEFT JOIN factdata.Source USING (fSourceKey) WHERE fNight BETWEEN ".$today." AND ".$today2;
    if ($trigger=="New")
        $query.=" AND ISNULL(fTriggerAcknowledged) ";
    if ($type)
        $query.=" AND fTriggerType=".$type;
    //echo $query;

    $result = $db->query($query)->fetchAll(PDO::FETCH_ASSOC);
    foreach($result as $row) 
    {
        if ($first_row == 0)
        {
            $first_row = 1;
            echo "<tr>\n";
            $colnames = array_keys($row);
            foreach($colnames as $colname){
                echo "<th>".$colname."</th>\n";
            }
            echo "</tr>\n";
        }
        echo "<tr>\n";
        foreach ($colnames as $key) {
            
            echo "<td>".$row[$key]."</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";
    echo "<hr size='2px' style='border-width:5px'>\n";
    echo "<h1>Additional Information</h1>\n";

    //obs_summary.php
    echo "<h2> From Observation-Summary: </h2>\n";
    echo "<iframe width='100%' height='315' src='https://fact-project.org/dch/obs_summary.php?d=".$year."-".$month."-".$day."&nolegend=yes' frameborder='0' allowfullscreen></iframe>\n";

    /*
    $query="SELECT fSourceKey AS 'Source', fStart AS 'Start of Observation', fData AS 'Settings' FROM factdata.Schedule WHERE ";
    $query.="fSTART BETWEEN DATE_ADD(DATE_FORMAT(".$today.", '%Y-%m-%d'), INTERVAL +18 HOUR) ";
    $query.="AND DATE_ADD(DATE_FORMAT(".$today2.", '%Y-%m-%d'), INTERVAL +35 HOUR) ";
    //$query.="AND fData='nodrs:true,grb:true'";
    $query.="AND NOT ISNULL(fData)";
    echo "<h2> ToO observations in schedule from ".$today." to ".$today2.": </h2>";
    echo "<table border='1' style='border-collapse:collapse'>\n";
    $first_row = 0;
    $colnames = "";
    $result = $db->query($query)->fetchAll(PDO::FETCH_ASSOC);
    foreach($result as $row) 
    {
        if ($first_row == 0)
        {
            $first_row = 1;
            echo "<tr>\n";
            $colnames = array_keys($row);
            foreach($colnames as $colname){
                echo "<th>".$colname."</th>\n";
            }
            echo "</tr>\n";
        }
        echo "<tr>\n";
        foreach ($colnames as $key) {
            
            echo "<td>".$row[$key]."</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";
    */

    $query="SELECT fSourceName AS 'Source', fStart AS 'Start of Observation', fData AS 'Settings', fUser AS 'User' ";
    $query.="FROM factdata.Schedule LEFT JOIN factdata.Source USING (fSourceKey) WHERE ";
    $query.="fSTART BETWEEN DATE_ADD(DATE_FORMAT(".$today.", '%Y-%m-%d'), INTERVAL +18 HOUR) ";
    $query.="AND DATE_ADD(DATE_FORMAT(".$today2.", '%Y-%m-%d'), INTERVAL +35 HOUR) ";
    //$query.="AND fData='nodrs:true,grb:true'";
    $query.="AND fMeasurementTypeKey=4";
    echo "<h2> Physics observations in schedule from ".$today." to ".$today2.": </h2>";
    echo "<table border='1' style='border-collapse:collapse'>\n";
    $first_row = 0;
    $colnames = "";
    $result = $db->query($query)->fetchAll(PDO::FETCH_ASSOC);
    foreach($result as $row) 
    {
        if ($first_row == 0)
        {
            $first_row = 1;
            echo "<tr>\n";
            $colnames = array_keys($row);
            foreach($colnames as $colname){
                echo "<th>".$colname."</th>\n";
            }
            echo "</tr>\n";
        }
        echo "<tr>\n";
        foreach ($colnames as $key) {
            
            echo "<td>".$row[$key]."</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n";

    // table with ToOs
    $query="SELECT fSourceName AS 'Source', CONCAT(ToOs.fRightAscension, '/', Source.fRightAscension) AS 'RA (Satellite/FACT)', ";
    $query.="CONCAT(ToOs.fDeclination, '/', Source.fDeclination) AS 'Dec (Satellite/FACT)', ";
    $query.="fLastUpdate AS 'ToO time', fTypeID AS 'PaketType' FROM factdata.ToOs LEFT JOIN factdata.Source USING (fSourceKey) ";
    $query.="WHERE fLastUpdate BETWEEN DATE_ADD(DATE_FORMAT(".$today.", '%Y-%m-%d'), INTERVAL +18 HOUR) ";
    $query.="AND DATE_ADD(DATE_FORMAT(".$today2.", '%Y-%m-%d'), INTERVAL +35 HOUR) ";
    echo "<h2> ToO observations in ToO-table from ".$today." to ".$today2.": </h2>";
    echo "<table border='1' style='border-collapse:collapse'>\n";
    $first_row = 0;
    $colnames = "";
    $result = $db->query($query)->fetchAll(PDO::FETCH_ASSOC);
    foreach($result as $row) 
    {
        if ($first_row == 0)
        {
            $first_row = 1;
            echo "<tr>\n";
            $colnames = array_keys($row);
            foreach($colnames as $colname){
                echo "<th>".$colname."</th>\n";
            }
            echo "</tr>\n";
        }
        echo "<tr>\n";
        foreach ($colnames as $key) {
            
            echo "<td>".$row[$key]."</td>\n";
        }
        echo "</tr>\n";
    }
    echo "</table>\n\n";

    //weather:
    echo "<h2>Weather Info:</h2>\n";
    echo "<image src='http://www.gtc.iac.es/multimedia/netcam/camaraAllSky.jpg' frameborder='0' allowfullscreen></image>\n";

    //visibility
    echo "<h2>Visibility:</h2>\n";
    echo "<image src='https://www.fact-project.org/scheduling/".$year."/".$month."/".$day."/".$today."-ZenithDistance.png' frameborder='0' allowfullscreen></image>\n";


    echo "<hr>\n";
    echo "<h2>Important Links for Flare Experts</h2>";
    echo "<li><a href='https://trac.fact-project.org/wiki/Protected/FlareAlertInfo'>All information on flare alerts in FACT</a></li>\n";
    echo "<ul>\n";

    echo "<li> Sending ToOs: <ul>\n";
    echo "<li><a href='https://trac.fact-project.org/wiki/Protected/FlareAlertInfo#Type1MoUpartners'>Alert to MoU partners</a></li>\n";
    echo "<li><a href='https://www.swift.psu.edu/toop/too.php'>Swift-ToO</a></li>\n";
    echo "<li>List of Previous Flare Alerts: <a href='https://trac.fact-project.org/wiki/FlareAlertsSent'>[old]</a> \n";
    echo "<a href='https://fact-project.org/run_db/db/printtable.php?fTable=FlareAlerts.Sent'>[new, view-only]</a> (add alert to list)</li>\n";
    echo "</li></ul>\n";

    echo "<li> Data Quality and Weather: <ul>\n";
    echo "<li><a href='https://www.fact-project.org/logbook/calendar.php?action=dayview&calendar=1&year=".$year."&month=".$month."&day=".$day."'>logbook ".$year."-".$month."-".$day."</a></li>\n";
    echo "<li><a href='https://fact-project.org/overview_video/".$year."/".$month."/".$day."/images'>Overview Images</a></li>\n";
    echo "<li>Weather info: <a href='http://www.magic.iac.es/site/weather/index.html'>MAGIC</a>, \n";
    echo "<a href='http://tngweb.tng.iac.es/weather/current'>TNG</a>,\n";
    echo "<a href='http://atmosportal.gtc.iac.es/'>GTC</a></li>\n";
    echo "<li><a href='http://www.gtc.iac.es/multimedia/webcamPopup.php?webcam=skycam'>GTC allsky cam current image</a></li>\n";
    echo "</li></ul>\n";

    echo "<li> Visibility and Scheduling: <ul>\n";
    echo "<li><a href='https://fact-project.org/showlog/?log=scheduler#bottom'>scheduler log</a>, ";
    echo "<a href='https://fact-project.org/showlog/?log=gcn#bottom'>gcn log</a></li>\n";
    echo "<li>FACT: <a href='https://www.fact-project.org/schedule'>Schedule</a>\n";
    echo "<a href='https://www.fact-project.org/dch/scheduling.php'>Visibility</a> </li>\n";
    echo "<li>Swift-XRT Schedule: \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".($day-1)."&a=0'>".$year."-".$month."-".($day-1)."</a>,  \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".$day."&a=0'>".$year."-".$month."-".$day."</a>,  \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".($day+1)."&a=0'>".$year."-".$month."-".($day+1)."</a>  \n";
    echo "(planned) \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".($day-1)."&a=1'>".$year."-".$month."-".($day-1)."</a>,  \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".$day."&a=1'>".$year."-".$month."-".$day."</a>,  \n";
    echo "<a href='https://www.swift.psu.edu/operations/obsSchedule.php?d=".$year."-".$month."-".($day+1)."&a=1'>".$year."-".$month."-".($day+1)."</a>  \n";
    echo "(achieved)</li>\n";
    echo "</li></ul>\n";
    //XMM, NuStar, Integral

    echo "<li> Other Information: <ul>\n";
    echo "<li><a href='https://trac.fact-project.org/browser/trunk/FACT%2B%2B/src/HeadersGCN.h'> Explanation Paket Types in FACT++</a></li>\n";
    echo "</li></ul>\n";

    echo "<li> GRBs: <ul>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/fermi_grbs.html'>Fermi-GBM GRBs</a> \n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/fermi.html'>Fermi</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/swift_grbs.html'>Swift-BAT GRBs</a> \n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/swift.html'>Swift</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/integral_grbs.html'>INTEGRAL GRBs</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/integral.html'>INTEGRAL</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/agile_grbs.html'>AGILE GRBs</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/agile.html'>AGILE</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/amon_hawc_events.html'>AMON HAWC Bursts</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/amon.html'>AMON</a>)</li>\n";
    echo "</li></ul>\n";

    echo "<li> Transients: <ul>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/fermi_lat_mon_trans.html'>Fermi-LAT monitored and transient</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/fermi.html'>Fermi</a>)</li>\n";
    echo "</li></ul>\n";

    echo "<li> Neutrinos: <ul>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/amon_ehe_events.html'>AMON EHE/HESE Events</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/amon.html'>AMON</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/amon_icecube_gold_bronze_events.html'>AMON IceCube BRONZE/GOLD Events</a>\n";
    echo "(<a href='https://gcn.gsfc.nasa.gov/amon.html'>AMON</a>)</li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/gcn3_archive.html'>GCN circulars</a></li>\n";
    echo "</li></ul>\n";

    echo "<li> GW: <ul>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/lvc.html'>LVC</a></li>\n";
    echo "<li><a href='https://gracedb.ligo.org/latest/'>latest GW-alerts</a></li>\n";
    echo "<li><a href='https://gcn.gsfc.nasa.gov/gcn3_archive.html'>GCN circulars</a></li>\n";
    echo "</li></ul>\n";
    echo "</ul>\n";
    // to be added
    // email template
    // flare summary (copy flare-alert files to gate)
    // internal qla links: 10 min, 5 min, significance (20 min, nightly)
    // make links dependent on flare type and if sourcekey is available
    // link to visibility plot (+ create them)
    // future dreams
    // interface to send email directly to both too-lists
    echo "<hr size='2px' style='border-width:5px'>\n";

?>
</body>
</html>
