void fresnellens_image()
{
    Double_t telzd = 0;      // [deg] Telescope orientation Zenith Distance
    Double_t telaz = 0;      // [deg] Telescope orientation Azimuth

    Double_t dzd   = 0;      // [deg] Relative angle of light ray Zd
    Double_t daz   = 0;      // [deg] Relative angle of light ray Az

    Double_t F     = 0.5021; // [m]   Distance of camera to lens
    //                       // This is different from F in MFresnelLens!

    // ----------------------------------------------

    MParList plist;
    MTaskList tlist;
    plist.AddToList(&tlist);

    MFresnelLens lens("Reflector");
    plist.AddToList(&lens);

    MPointingPos pointpos;
    pointpos.SetLocalPosition(telzd, telaz);
    plist.AddToList(&pointpos);

    MPointingPos srcpos("Source");
    plist.AddToList(&srcpos);

    MGeomCamFAMOUS geom(F);
    plist.AddToList(&geom);

    MSimRays simrays;
    simrays.SetNameReflector("Reflector");
    //simrays.SetWavelengthRange(300, 900);
    tlist.AddToList(&simrays);

    MHPhotonEvent planeG(1, "HPhotonEventGround");
    MHPhotonEvent plane0(2, "HMirrorPlane0");
    MHPhotonEvent plane2(2, "HMirrorPlane2");
    MHPhotonEvent plane3(2, "HMirrorPlane3");
    MHPhotonEvent plane4(2, "HMirrorPlane4");
    MHPhotonEvent planeC(5, "HPhotonEventCamera");

    planeG.SetMaxImpact(60);

    MFillH fillG(&planeG, "MPhotonEvent", "FillGround");
    MFillH fill0(&plane0, "MirrorPlane0", "FillReflector");
    MFillH fill2(&plane2, "MirrorPlane2", "FillCandidates");
    MFillH fill3(&plane3, "MirrorPlane3", "FillReflected");
    MFillH fill4(&plane4, "MirrorPlane4", "FillCameraPlane");
    MFillH fillC(&planeC, "MPhotonEvent", "FillCamera");

    fillG.SetNameTab("Ground",      "Photon distribution at ground");
    fill0.SetNameTab("LensIn",      "Photon distribution at plane of lens hit surface");
    fill2.SetNameTab("Candidates",  "*Can hit* photon distribution at reflector plane w/ camera shadow");
    fill3.SetNameTab("LensOut",     "Photon distribution at plane output surface");
    fill4.SetNameTab("CameraPlane", "Photon distribution at camera plane");
    fillC.SetNameTab("Camera",      "Photon distribution which hit a sensor in the focal plane");

    tlist.AddToList(&fillG);

    MSimReflector simref;
    simref.SetNameReflector("Reflector");
    simref.SetDetectorMargin(-1);
    tlist.AddToList(&simref);

    tlist.AddToList(&fill0);
    tlist.AddToList(&fill2);
    tlist.AddToList(&fill3);
    tlist.AddToList(&fill4);
    tlist.AddToList(&fillC);

    //tlist.SetAccelerator(MTask::kAccDontReset|MTask::kAccDontTime);

    MStatusDisplay *disp = new MStatusDisplay;

    MEvtLoop loop;
    loop.SetDisplay(disp);
    loop.SetParList(&plist);

    srcpos.SetLocalPosition(dzd, daz);
    if (!loop.Eventloop(100))
        return;
}

