#ifndef MARS_MMcEnergyEst
#define MARS_MMcEnergyEst

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TArrayD
#include <TArrayD.h>
#endif

class MMcEnergyEst : public MParContainer
{
private:

  Char_t *fInFile, *fOutFile;
  Char_t *fHillasName, *fHillasSrcName, *fHadronnessName;
  Int_t   fNevents;
  Float_t fMaxHadronness, fMaxAlpha, fMaxDist;

  TArrayD fA;
  TArrayD fB;

public:
  MMcEnergyEst(const char *name=NULL, const char *title=NULL);

  void SetInFile(Char_t *name)         {fInFile = name;}
  void SetOutFile(Char_t *name)        {fOutFile = name;}
  void SetHillasName(Char_t *name)     {fHillasName = name;}
  void SetHillasSrcName(Char_t *name)  {fHillasSrcName = name;}
  void SetHadronnessName(Char_t *name) {fHadronnessName = name;}
  void SetNevents(Int_t n)             {fNevents = n;}
  void SetMaxHadronness(Float_t x)     {fMaxHadronness = x;}
  void SetMaxAlpha(Float_t x)          {fMaxAlpha = x;}
  void SetMaxDist(Float_t x)           {fMaxDist = x;}

  Char_t* GetInFile()         {return fInFile;}
  Char_t* GetOutFile()        {return fOutFile;}
  Char_t* GetHillasName()     {return fHillasName;}
  Char_t* GetHillasSrcName()  {return fHillasSrcName;}
  Char_t* GetHadronnessName() {return fHadronnessName;}
  Int_t   GetNevents()        {return fNevents;}
  Float_t GetMaxHadronness()  {return fMaxHadronness;}
  Float_t GetMaxAlpha()       {return fMaxAlpha;}
  Float_t GetMaxDist()        {return fMaxDist;}

  Double_t GetCoeff(Int_t i) { return i<fA.GetSize()? fA[i] : fB[i-fA.GetSize()]; }

  void FindParams();
  void Print(Option_t *o="");

  ClassDef(MMcEnergyEst, 1) // Class for optimization of Energy estimator
};

#endif

