/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Abelardo Moralejo  04/2003 <mailto:moralejo@pd.infn.it>
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MMcEnergyMigration                                                    //
//                                                                         //
//   This task fills the histograms contained in the                       //
//   class MHMcEnergyMigration                                             //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MMcEnergyMigration.h"
#include "MHMcEnergyMigration.h"

#include "MLog.h"
#include "MLogManip.h"

#include "MParList.h"

ClassImp(MMcEnergyMigration);

// --------------------------------------------------------------------------
//
// Default Constructor
//
MMcEnergyMigration::MMcEnergyMigration(const char *name, const char *title)
{
  fName  = name  ? name  : "MMcEnergyMigration";
  fTitle = title ? title : "Task to fill histograms in MHMcEnergyMigration";
}

// --------------------------------------------------------------------------
//
// Destructor
//
MMcEnergyMigration::~MMcEnergyMigration()
{
  if (fHistMigration)
    delete fHistMigration;
}

// --------------------------------------------------------------------------
//
// Preprocess: look for the MHMcEnergyMigration object in the parameter list.
//
Bool_t MMcEnergyMigration::PreProcess(MParList *pList)
{
  fHistMigration = (MHMcEnergyMigration*)pList->FindObject("MHMcEnergyMigration");
  if (!fHistMigration)
    {
      *fLog << dbginf << "MHMcEnergyMigration not found... aborting." << endl;
      return kFALSE;
    }

  fHistMigration->SetupFill(pList);

  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Fill the histograms in the MHMcEnergyMigration object.
//
Bool_t MMcEnergyMigration::Process()
{
  fHistMigration->Fill(0);  // Argument of Fill is dummy.
  return kTRUE;
}

// --------------------------------------------------------------------------
//
// Postprocessing does nothing at the moment.
//
Bool_t MMcEnergyMigration::PostProcess()
{
  return kTRUE;
}


