#ifndef MARS_MHThetabarTheta
#define MARS_MHThetabarTheta

#ifndef MARS_MH
#include "MH.h"
#endif
#ifndef ROOT_TProfile
#include "TProfile.h"
#endif

class MTime;
class MMcEvt;

class MParList;

class MHThetabarTheta : public MH
{
private:
    MTime   *fTime;   //!
    MMcEvt  *fMcEvt;  //!

    TProfile fHist;

public:
    MHThetabarTheta(const char *name=NULL, const char *title=NULL);

    virtual Bool_t SetupFill(const MParList *pList);
    virtual Bool_t Fill(const MParContainer *par);

    const TProfile *GetHist() { return &fHist; }
    const TProfile *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");

    ClassDef(MHThetabarTheta, 0) //Profile histogram Thetabar vs. time

};

#endif











