// ==========================================================================
// ============= see ratescan function at the end of the file ===============
// ==========================================================================

MStatusDisplay *d = new MStatusDisplay;
TList list[11];

void plot(const char *tab, const char *title="")
{
    gROOT->SetSelectedPad(0);
    d->AddTab(tab);

    gPad->SetGrid();
    gPad->SetLogy();

    TH1D h0("frame", title, 1000, 0, 1000);
    h0.SetStats(kFALSE);
    h0.SetXTitle("Threshold [dac]");
    h0.SetYTitle("Trigger rate [Hz]");
    h0.SetDirectory(0);
    h0.SetMaximum(1e8);
    h0.SetMinimum(0.01);
    h0.DrawCopy();
}

void same(const char *id, const char *fmt, bool boards=true, bool patches=true)
{
    for (int i=0; i<8; i++)
    {
        TGraph *g = (TGraph*)list[i+3].FindObject(id);
        if (!g)
        {
            cout << "==W==> " << id << " not found in i=" << i+3 << endl;
            return;
        }

        g->SetMarkerStyle(kFullDotSmall);
        g->SetMarkerColor(kGreen+2);
        g->SetLineColor(kGreen+2);
        if (patches)
            g->DrawClone(fmt);

        if (g->Eval(400)>10)
            cout << "Patch " << setw(3) << i << ": C" << i/40 << " B" << (i%40)/4 << " P" << (i%40)%4 << ": " << g->Eval(400) << "Hz @ th=400" << endl;
    }

    for (int i=0; i<2; i++)
    {
        TGraph *g = (TGraph*)list[i+1].FindObject(id);
        if (!g)
        {
            cout << "==W==> " << id << " not found in i=" << i+1 << endl;
            return;
        }

        g->SetMarkerStyle(kFullDotSmall);
        g->SetMarkerColor(kBlue);
        g->SetLineColor(kBlue);
        if (boards)
            g->DrawClone(fmt);

        if (g->Eval(400)>10)
            cout << "Board " << setw(3) << i << ": C" << i/10 << " B" << i%10 << ":    " << g->Eval(400) << "Hz @ th=400" << endl;
    }


    TGraph *g001 = (TGraph*)list[0].FindObject(id);
    if (!g001)
    {
        cout << "==W==> " << id << " not found in i=0" << endl;
        return;
    }

    g001->SetMarkerStyle(boards||patches?kFullDotMedium:kFullDotSmall);
    g001->DrawClone(fmt);
}

void read(const char *filename)
{
    fits fin(filename);
    if (!fin)
        return;

    cout << '\n' << filename << '\n';
    cout << setfill('-') <<setw(strlen(filename)) << '-' << setfill(' ') << endl;

    //fin.PrintColumns();

    ULong64_t start;
    UInt_t    threshold;
    Float_t   time;
    Float_t   ontime;
    Float_t   Rc;
    Float_t   Rb[2];
    Float_t   Rp[8];

    fin.SetPtrAddress("Id", &start);
    fin.SetPtrAddress("Threshold", &threshold);
    fin.SetPtrAddress("ElapsedTime", &time);
    fin.SetPtrAddress("RelOnTime", &ontime);
    fin.SetPtrAddress("TriggerRate", &Rc);
    fin.SetPtrAddress("BoardRate", Rb);
    fin.SetPtrAddress("PatchRate", Rp);

    ULong_t first = 0;

    TGraph *g[11];

    while (fin.GetNextRow())
    {
        if (first==0 || first!=start)
        {
            first = start;

            MTime t;
            t.SetUnixTime(start);

            TString name = t.GetString();
            name = name(0, 19);

            cout << name << endl;

            for (int i=0; i<11; i++)
            {
                g[i] = new TGraph;
                g[i]->SetMarkerStyle(kFullDotMedium);
                g[i]->SetName(name);
                g[i]->SetTitle(t.GetStringFmt("%H:%M:%S"));

                list[i].Add(g[i]);
            }
        }

        g[0]->SetPoint(g[0]->GetN(), threshold, Rc/ontime);
        for (int i=0; i<2; i++)
            g[i+1]->SetPoint(g[i+1]->GetN(), threshold, Rb[i]);
        for (int i=0; i<8; i++)
            g[i+3]->SetPoint(g[i+3]->GetN(), threshold, Rp[i]);
    }
}

// ==========================================================================
// ==========================================================================

void ratescan()
{
    cout << setprecision(4);

    // ----------------------------------------------------------------------
    // Read a fits with ratescan data. You can read more than one file if
    // you want to plot data from more than one day.
    read("20191003.RATE_SCAN_DATA.fits");
    //read("20191004.RATE_SCAN_DATA.fits");

    // This produces an output like this printing all IDs of ratescans
    // contained on the files
    //
    // ==================================
    // 20191003.RATE_SCAN_DATA.fits
    // ----------------------------
    // 03.10.2019 22:34:01
    // 03.10.2019 22:40:53
    // 03.10.2019 22:47:51
    // 03.10.2019 22:50:28
    // ==================================


    // ----------------------------------------------------------------------
    // The plot-function adds a tab to the display. The first argument is
    // the name of the tab. The second argument can be omitted and is
    // displayed in the statusline

    plot("Scan1", "Scan with good weather");


    // ----------------------------------------------------------------------
    // The same-function allows to plot a ratescan from the file into the
    // just opened tab. More than one ratescan can be plotted in the same
    // tab.
    //
    // The first argument is the ID of the ratescan as listed above. The
    // second argument is the option given to the TGraph (see ROOT's
    // TGraph::Paint documentation for details). "LP" is a good start. It
    // plots markers ('P') and connects them by a straight line ('L').
    //
    // The thirs and fourth argument can be omitted. They are booleans
    // (true, false) and define whether also the patch and board rates
    // shall be plotted.

    same("03.10.2019 22:34:01", "LP");
    //same("03.10.2019 22:40:53", "LP");

    //plot("Tab2", "Same with Patch and Baord rates");
    //same("03.10.2019 22:34:01", "LP");

    // ----------------------------------------------------------------------
    // To write the output to a files, use the following line. This can be
    // a root-file, a pdf-file, png-files, ...  Root files can be read back
    // with showplot or simply with ROOT's TBrowser.

    // d->SaveAs("ratescan.root");
}
