int HandleInput(int evtnum)
{
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);

    while (1)
    {
        timer.TurnOn();
        const char *gl = Getline("Type 'q' to exit, or event number and <return> to go on: ");
        timer.TurnOff();

        TString input = gl;
        if (input=="q\n")
            return -1;

        if (input=="\n")
            return evtnum+1;

        return atoi(input.Data());
    };

    return -1;
}

void plot_callisto(const char *fname)
{
    TFile f(fname);

    TTree *T = f.Get("Events");

    MSignalCam *signal = NULL;
    T->SetBranchAddress("MSignalCam.", &signal);

    MGeomCamFAMOUS geom(0.5, kFALSE);

    MHCamera cam_signal(geom);
    MHCamera cam_cleaned(geom);
    MHCamera cam_time(geom);

    cam_signal.SetName("Signal");
    cam_cleaned.SetName("Cleaned");
    cam_time.SetName("Time");
    cam_signal.SetMinimum(0);
    cam_cleaned.SetMinimum(0);

    TCanvas c;
    c.Divide(2,2);

    c.cd(1);
    cam_signal.Draw();

    c.cd(2);
    cam_cleaned.Draw();

    c.cd(3);
    cam_time.Draw();

    int evtnum = 0;
    while (evtnum>=0)
    {
        if (evtnum>=T->GetEntries())
            evtnum = 0;

        T->GetEntry(evtnum);

        //  0: Number of Photons*PixRatio <default>
        //  1: Error*sqrt(PixRatio)
        //  2: Cleaning level = Num Photons*sqrt(PixRatio)/Error
        //  3: Number of Photons
        //  4: Error
        //  5: Island index
        //  6: arrival time of mapped pixels
        //  7: arrival time if signa avove 20phe
        //  8: arrival time
        // 10: as 0, but returns kFALSE if signal <=0
        // 11: as 8, but returns kFALSE if signal <=0

        cam_signal.SetCamContent(*signal, 10); // num phot uncleaned
        cam_cleaned.SetCamContent(*signal, 3); // num phot cleaned
        cam_time.SetCamContent(*signal, 8); // arr time cleaned

        for (int i=0; i<4; i++)
        {
            c.GetPad(i+1)->Modified();
            c.GetPad(i+1)->Update();
        }

        evtnum = HandleInput(evtnum);
    }
}
