#ifndef MARS_MFCT1SelFinal
#define MARS_MFCT1SelFinal

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MSelFinal                                                               //
//                                                                         //
// Class to evaluate final cuts                                            //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MGeomCam;
class MCerPhotEvt;
class MHillas;
class MHillasSrc;
class MMcEvt;
class MHadronness;

class MFCT1SelFinal : public MFilter
{
private:
    MGeomCam    *fCam;      // Camera Geometry 
    MCerPhotEvt *fEvt;      // Cerenkov Photon Event 
    MMcEvt      *fMcEvt;       
    MHillas     *fHil;       
    MHillasSrc  *fHilSrc;       
    MHadronness *fHadronness;       

    Double_t     fMm2Deg;   // conversion mm to degrees in camera
    Int_t        fCut[4];
    TString      fHilName;
    TString      fHilSrcName;
    TString      fHadronnessName;
 
    Float_t      fHadronnessMax;
    Float_t      fAlphaMax;
    Float_t      fDistMax;

    Bool_t       fResult;


public:
    MFCT1SelFinal(const char *HilName="MHillas", const char *HilSrcName="MHillasSrc",
                  const char *name=NULL, const char *title=NULL);

    void SetHadronnessName(const TString name) { fHadronnessName = name; }
    Bool_t IsExpressionTrue() const  { return fResult; }

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    void SetCuts(Float_t hadmax, Float_t alphamax, Float_t distmax); 

    ClassDef(MFCT1SelFinal, 0)   // Class to evaluate final cuts
};

#endif











