WITH Table0 AS
(
   SELECT
      Weight,
      INTERVAL(Zd,            %106:theta)        AS `.theta`,
      INTERVAL(LogEnergyEst,  %107:energyest)    AS `.energyest`,
      INTERVAL(log10(Energy), %108:energysim)    AS `.energysim`,
      (%109:spectrum)/pow(Energy, SpectralIndex) AS SpectralWeight,  -- FIXME: Is this correct for files with different Slopes?

      LogEnergyEst - log10(Energy) AS Residual
   FROM
      Excess
-- Instead of using %%0:columns, we could join back with the data we need
--   INNER JOIN
--      factmc.EventsMC USING(FileId, EvtNumber, CorsikaNumReuse)
--   INNER JOIN
--      factmc.RunInfoMC USING(FIleId)
),

Table1 AS
(
   SELECT
      `.energyest`,
      `.energysim`,

      -- Signal, Background, Excess
      SUM(  IF(Weight>0,     ZdWeight*SpectralWeight,       0)) OVER EnergyEst  AS  `SignalW`,
      SUM(  IF(Weight<0,     ZdWeight*SpectralWeight,       0)) OVER EnergyEst  AS  `BackgroundW`,
      SUM(  IF(Weight>0, POW(ErrZdWeight*SpectralWeight,2), 0)) OVER EnergyEst  AS  `SignalW2`,
      SUM(  IF(Weight<0, POW(ErrZdWeight*SpectralWeight,2), 0)) OVER EnergyEst  AS  `BackgroundW2`,
      COUNT(IF(Weight>0, 1, NULL))                              OVER EnergyEst  AS  `SignalN`,
      COUNT(IF(Weight<0, 1, NULL))                              OVER EnergyEst  AS  `BackgroundN`,
      -- SUM(  IF(Table9.Weight>0,     ThetaHist.Weight*spectrum/Energy,    0)) OVER EnergyEst  AS  `SignalW`,
      -- SUM(  IF(Table9.Weight<0,     ThetaHist.Weight*spectrum/Energy,    0)) OVER EnergyEst  AS  `BackgroundW`,
      -- SUM(  IF(Table9.Weight>0, POW(ThetaHist.Weight*spectrum/Energy,2), 0)) OVER EnergyEst  AS  `SignalW2`,
      -- SUM(  IF(Table9.Weight<0, POW(ThetaHist.Weight*spectrum/Energy,2), 0)) OVER EnergyEst  AS  `BackgroundW2`,

      -- Threshold
      SUM(    Weight *    ZdWeight*SpectralWeight   ) OVER EnergySim  AS  `ThresholdW`,
      SUM(POW(Weight * ErrZdWeight*SpectralWeight,2)) OVER EnergySim  AS  `ThresholdW2`,
      SUM(    Weight                                ) OVER EnergySim  AS  `ThresholdN`,
      -- SUM(     Table9.Weight/Energy * ThetaHist.Weight*spectrum     ) OVER EnergySim  AS  `ThresholdW`,
      -- SUM( POW(Table9.Weight/Energy * ThetaHist.Weight*spectrum,2)  ) OVER EnergySim  AS  `ThresholdW2`,
      -- SUM(     Table9.Weight/Energy                                 ) OVER EnergySim  AS  `ThresholdN`

      -- Estimators
      SUM(IF(Weight>0,                 ZdWeight*SpectralWeight,  0)) OVER EnergySim  AS  SimW,
      SUM(IF(Weight>0,     Residual*   ZdWeight*SpectralWeight,  0)) OVER EnergyEst  AS  EstSum,
      SUM(IF(Weight>0,     Residual*   ZdWeight*SpectralWeight,  0)) OVER EnergySim  AS  SimSum,
      SUM(IF(Weight>0, POW(Residual,2)*ZdWeight*SpectralWeight,  0)) OVER EnergyEst  AS  EstSum2,
      SUM(IF(Weight>0, POW(Residual,2)*ZdWeight*SpectralWeight,  0)) OVER EnergySim  AS  SimSum2,

      -- Migration
      SUM(Weight * ZdWeight*SpectralWeight) OVER Migration  AS  `MigrationW`,
      SUM(Weight                          ) OVER Migration  AS  `MigrationN`

      -- FIXME: Add ExcessN vs theta
      -- FIXME: Add ExcessW vs theta

   FROM
      Table0
   INNER JOIN
      ThetaDistribution USING(`.theta`)
   WINDOW
      EnergyEst AS (PARTITION BY `.energyest`),
      EnergySim AS (PARTITION BY `.energysim`),
      Migration AS (PARTITION BY `.energysim`,`.energyest`)
)

SELECT DISTINCT

   *,

   `SignalW` - `BackgroundW`/5 AS `ExcessW`,
   `SignalN` - `BackgroundN`/5 AS `ExcessN`,

   ExcErr(`SignalW2`, `BackgroundW2`/5) AS `ErrExcessW`,
   ExcErr(`SignalN`,  `BackgroundN` /5) AS `ErrExcessN`,

   IF(SignalW=0, 0, EstSum / SignalW) AS BiasEst,  -- FIMXE: Is NULL better?
   IF(SimW   =0, 0, SimSum / SimW)    AS BiasSim,  -- FIMXE: Is NULL better?

   IF(SignalW=0, 0, SQRT(EstSum2/SignalW - POW(EstSum/SignalW, 2))) AS ResolutionEst,
   IF(SimW   =0, 0, SQRT(SimSum2/SimW    - POW(SimSum/SimW,    2))) AS ResolutionSim

FROM
   Table1
