WITH BinnedData AS -- Bin data and create sums per bin
(
   SELECT
      %101:bin,
      SUM(`Signal`)        AS  `Signal`,
      SUM(`Background`)/5  AS  `Background`,
      SUM(SumEnergyEst)    AS  SumEnergyEst,
      SUM(SumW)            AS  SumW
   FROM
      SummaryData
   GROUP BY
      %101:bin
),
ResultData AS -- Calculate results for all bins
(
   SELECT
      *,
      SQRT(`Signal`)                  AS  ErrSignal,
      SQRT(`Background`)              AS  ErrBackground,
      `Signal` - `Background`         AS  Excess,
      ExcErr(`Signal`, `Background`)  AS  ErrExcess,
      LiMa(  `Signal`, `Background`)  AS  Significance
   FROM
      BinnedData
),
CombinedData AS -- Joind data together and for conveninece (easier reading of the query) rename the columns
(
   SELECT
      %102:id.%101:bin,
      %102:id.lo,
      %102:id.hi,
      (%102:id.lo+%102:id.hi)/2  AS  center,
      %102:id.Scale,
      Data.Excess,
      Data.Signal,
      Data.Background,
      Data.ErrExcess,
      Data.ErrSignal,
      Data.ErrBackground,
      Significance,
      SumEnergyEst/SumW  AS  AvgEnergyEst,
      %102:id.ExcessFluxW  AS  SimExcess,
      %102:id.ErrExcessFluxW  AS  ErrSimExcess,
      Sim.SimFluxW/%103:weight  AS  SimFluxW,          -- Possible correcton for already applied ZdWeights
      Sim.ErrSimFluxW/%104:errweight  AS  ErrSimFluxW  -- Possible correcton for already applied ZdWeights
   FROM
      ResultData Data
   INNER JOIN
      %105:join1
   INNER JOIN
      %106:join2
)
SELECT -- Return final result
   *,
   SimExcess/SimFluxW      AS  Efficiency,
   Excess/SimExcess*Scale  AS  ExcessRatio,
   Excess/SimExcess*Scale
      * SQRT(
          + POW(ErrExcess    / Excess,    2)
          + POW(ErrSimExcess / SimExcess, 2)
        )  AS  ErrExcessRatio,
   Excess/SimExcess*SimFluxW*Scale  AS  Flux,
   Excess/SimExcess*SimFluxW*Scale
      * SQRT(
          + POW(ErrExcess    / Excess,    2)
          + POW(ErrSimExcess / SimExcess, 2)
          + POW(ErrSimFluxW  / SimFluxW,  2)
        )  AS  ErrFlux
FROM
   CombinedData
WHERE
   Excess>0
ORDER BY
   %101:bin
