WITH Theta AS  -- Get Total Observation Time
(
   SELECT SUM(OnTime) AS ObsTime FROM ThetaDist
),
Area AS -- Get total simulated area
(
   SELECT POW(MinImpactHi,2)*PI() AS Area FROM MonteCarloArea
),
Binning AS -- Get binning and calculate weights for each bin
(
   SELECT
      *,
      1000/(POW(10,hi)-POW(10,lo))/Area/ObsTime  AS  Scale
   FROM
      BinningEnergy_%100:binning
   CROSS JOIN
      Theta, Area
),
Analyzed AS -- Summarizy data after cuts (analyzed) in bins
(
   SELECT
      `.%100:binning:_est`,
      SUM(SignalN)        AS  SignalN,
      SUM(SignalW)        AS  SignalW,
      SUM(SignalW2)       AS  SignalW2,
      SUM(BackgroundN)    AS  BackgroundN,
      SUM(BackgroundW)    AS  BackgroundW,
      SUM(BackgroundW2)   AS  BackgroundW2,
      SUM(ResidualW)      AS  ResidualW,
      SUM(ResidualW2)     AS  ResidualW2,
      SUM(SumEnergySimW)  AS  SumEnergySimW,
      SUM(SumEnergyEstW)  AS  SumEnergyEstW
   FROM
      AnalysisMC
   GROUP BY
      `.%100:binning:_est`
)
SELECT -- Return Result
   *,
   SignalN - BackgroundN/5                 AS  ExcessN,
   SQRT(SignalN + BackgroundN/25)          AS  ErrExcessN,
   SQRT(SignalN)                           AS  ErrSignalN,
   SQRT(BackgroundN)                       AS  ErrBackgroundN,
   Scale*SignalW                           AS  SignalFluxW,
   Scale*BackgroundW/5                     AS  BackgroundFluxW,
   Scale*(SignalW - BackgroundW/5)         AS  ExcessFluxW,
   Scale*SQRT(SignalW2)                    AS  ErrSignalFluxW,
   Scale*SQRT(BackgroundW2)/5              AS  ErrBackgroundFluxW,
   Scale*SQRT(SignalW2 + BackgroundW2/25)  AS  ErrExcessFluxW,
   SumEnergyEstW/SignalW                   AS  AvgEnergyEstW,
   SumEnergySimW/SignalW                   AS  AvgEnergySimW,
   IF(SignalW>0, ResidualW/SignalW,                                                             NULL)  AS  BiasW,
   IF(SignalW>0, ResidualW/SignalW*SQRT(ResidualW2/POW(ResidualW,2) + SignalW2/POW(SignalW,2)), NULL)  AS  ErrBiasW,
   IF(SignalW>0, SQRT(ResidualW2/SignalW - POW(ResidualW/SignalW, 2)),                          NULL)  AS  ResolutionW
FROM
   Analyzed
INNER JOIN
   Binning ON `.%100:binning:_est`=bin
