WITH BinnedData AS -- Bin data and create sums per bin
(
   SELECT
      %101:bin,

      SUM(`Signal`)        AS  `Signal`,
      SUM(`Background`)/5  AS  `Background`,
      SUM(SumEnergyEst)    AS  SumEnergyEst,
      SUM(SumW)            AS  SumW
   FROM
      SummaryData
   GROUP BY
      %101:bin
),
Data AS -- Integral is a placeholder for the bin and all following bins
(
   SELECT
      *,
      SUM(`Signal`)     OVER Integral     AS  IntegralSignal,
      SUM(`Background`) OVER Integral /5  AS  IntegralBackground,
      SUM(SumEnergyEst) OVER Integral     AS  IntegralEnergyEst,
      SUM(SumW)         OVER Integral     AS  IntegralSumW
   FROM
      BinnedData
   WINDOW
      Integral AS (ORDER BY %101:bin DESC)
),
CombinedData AS -- Joind data together and for conveninece (easier reading of the query) rename the columns
(
   SELECT
      %102:id.%101:bin,
      %102:id.lo,
      %102:id.hi,
      (%102:id.lo+%102:id.hi)/2  AS  center,
      %102:id.Width,
      %102:id.AreaTime,

      `Signal`,
      `Background`,

      IntegralSignal,
      IntegralBackground,

      `Signal` - `Background`                     AS  Excess,
      SQRT(`Signal`)                              AS  ErrSignal,
      SQRT(`Background`)                          AS  ErrBackground,
      ExcErr(`Signal`, `Background`)              AS  ErrExcess,
      LiMa(  `Signal`, `Background`)              AS  Significance,

      IntegralSignal - IntegralBackground         AS  IntegralExcess,
      SQRT(IntegralSignal)                        AS  ErrIntegralSignal,
      SQRT(IntegralBackground)                    AS  ErrIntegralBackground,
      ExcErr(IntegralSignal, IntegralBackground)  AS  ErrIntegralExcess,
      LiMa(  IntegralSignal, IntegralBackground)  AS  IntegralSignificance,

      SumEnergyEst/SumW  AS  AvgEnergyEst,
      IntegralEnergyEst/IntegralSumW  AS  IntegralAvgEnergyEst,

      %102:id.ExcessFluxW  AS  SimExcess,
      %102:id.ErrExcessFluxW  AS  ErrSimExcess,
      %102:id.IntegralExcessFluxW  AS  IntegralSimExcess,
      %102:id.ErrIntegralExcessFluxW  AS  ErrIntegralSimExcess,

      -- For flux-vs-theta: Correction for already applied ZdWeights
      Sim.SimFluxW/%103:weight  AS  SimFluxW,
      Sim.ErrSimFluxW/%104:errweight  AS  ErrSimFluxW,
      Sim.IntegralSimFluxW/%103:weight  AS  IntegralSimFluxW,
      Sim.ErrIntegralSimFluxW/%104:errweight  AS  ErrIntegralSimFluxW
   FROM
      Data
   INNER JOIN
      %105:join1
   INNER JOIN
      %106:join2
),
Spectrum AS
(
SELECT -- Return final result
   *,

   -- Differetial Spectrum

   SimExcess/SimFluxW  AS  Efficiency,

   Excess/SimExcess/Width/AreaTime  AS  ExcessRatio,
   Excess/SimExcess/Width/AreaTime
      * SQRT(
          + POW(ErrExcess    / Excess,    2)
          + POW(ErrSimExcess / SimExcess, 2)
        )  AS  ErrExcessRatio,


   Excess/SimExcess*SimFluxW/Width/AreaTime  AS  Flux,
   Excess/SimExcess*SimFluxW/Width/AreaTime
      * SQRT(
          + POW(ErrExcess    / Excess,    2)
          + POW(ErrSimExcess / SimExcess, 2)
          + POW(ErrSimFluxW  / SimFluxW,  2)
        )  AS  ErrFlux,

   -- Integral Spectrum

   IntegralSimExcess/IntegralSimFluxW  AS  IntegralEfficiency,

   IntegralExcess/IntegralSimExcess/AreaTime  AS  IntegralExcessRatio,
   IntegralExcess/IntegralSimExcess/AreaTime
      * SQRT(
          + POW(ErrIntegralExcess    / IntegralExcess,    2)
          + POW(ErrIntegralSimExcess / IntegralSimExcess, 2)
        )  AS  ErrIntegralExcessRatio,


   IntegralExcess/IntegralSimExcess*IntegralSimFluxW/AreaTime  AS  IntegralFlux,
   IntegralExcess/IntegralSimExcess*IntegralSimFluxW/AreaTime
      * SQRT(
          + POW(ErrIntegralExcess    / IntegralExcess,    2)
          + POW(ErrIntegralSimExcess / IntegralSimExcess, 2)
          + POW(ErrIntegralSimFluxW  / IntegralSimFluxW,  2)
        )  AS  ErrIntegralFlux

FROM
   CombinedData
WHERE
   Excess>0
ORDER BY
   %101:bin
)
SELECT
   *,

   -- Integrated Spectrum

   SUM(Flux*Width) OVER Integral AS IntegratedFlux,
   SQRT(SUM(POW(ErrFlux*Width,2)) OVER Integral) AS ErrIntegratedFlux

FROM
   Spectrum

WINDOW
   Integral AS (ORDER BY %101:bin DESC)
