#ifndef MARS_MHMcEnergyMigration
#define MARS_MHMcEnergyMigration

#ifndef MARS_MH
#include "MH.h"
#endif

#ifndef ROOT_TH3
#include "TH3.h"
#endif

#ifndef ROOT_TH2
#include "TH2.h"
#endif

class MMcEvt;
class MEnergyEst;
class MParList;

class MHMcEnergyMigration : public MH
{
private:
    MMcEvt      *fMcEvt; //!
    MEnergyEst  *fEnergy; //!

    TH3D        fHist;

public:
    MHMcEnergyMigration(const char *name=NULL, const char *title=NULL);

    Bool_t SetupFill(const MParList *pList);
    Bool_t Fill(const MParContainer *par, Double_t w=1);

    const TH3D *GetHist() { return &fHist; }
    const TH3D *GetHist() const { return &fHist; }

    TH1 *GetHistByName(const TString name) { return &fHist; }

    void Draw(Option_t *option="");
    TObject *DrawClone(Option_t *option="") const;

    ClassDef(MHMcEnergyMigration, 1) //3D-histogram   E-true E-est Theta

};

#endif



