#ifndef MARS_MHMcTriggerLvl2
#define MARS_MHMcTriggerLvl2

#ifndef MARS_MH
#include "MH.h"
#endif

class TH1F;
class TF1;
class MMcTriggerLvl2;

class MHMcTriggerLvl2 : public MH
{
 public:
 

private:

    TH1F *fHistLutPseudoSize;        // Histogram of fLutPseudoSize
    TH1F *fHistLutPseudoSizeNorm;    // Histogram of fLutPseudoSize normalized on integral of distribution
    TH1F *fHistPseudoSize;           // Histogram of fPseudoSize
    TH1F *fHistPseudoSizeNorm;       // Histogram of fPseudoSize normalized on integral of distribution
    TH1F *fHistSizeBiggerCell;       // Histogram of fSizeBiggerCell
    TH1F *fHistSizeBiggerCellNorm;   // Histogram of fSizeBiggerCell normalized on integral of distribution

    TF1* fFNorm;                      // Function used to normalize histograms

    static Int_t fColorLps;
    static Int_t fColorSbc;
    static Int_t fColorPs;
    
public:
    MHMcTriggerLvl2(const char *name=NULL, const char *title=NULL);
    ~MHMcTriggerLvl2();

    Bool_t Fill(const MParContainer *par, Double_t w=1);

    TH1 *GetHistByName(const TString name);

    TH1F *GetHistfLutPseudoSize() const { return fHistLutPseudoSize; }
    TH1F *GetHistfLutPseudoSizeNorm() const { return fHistLutPseudoSizeNorm; }
    TH1F *GetHistfPseudoSize()  const { return fHistPseudoSize; }
    TH1F *GetHistfPseudoSizeNorm()  const { return fHistPseudoSizeNorm; }
    TH1F *GetHistfSizeBiggerCell()  const { return fHistSizeBiggerCell; }
    TH1F *GetHistfSizeBiggerCellNorm()  const { return fHistSizeBiggerCellNorm; }

    void Draw(Option_t *opt=NULL);
    TObject *DrawClone(Option_t *opt=NULL) const;

    TH1 *NormalizeHist(TH1 *histNorm, TH1 *hist) const;

    ClassDef(MHMcTriggerLvl2, 1) // Container which holds histograms for the Trigger Level2 image parameters

private:

    TObject *DrawHist(TH1 &hist, TH1 &histNorm, const TString &canvasname, Int_t &colore) const;

};


#endif
