void drstemp(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    double time;
    file.SetPtrAddress("Time", &time);

    float temp[160];
    file.SetPtrAddress("temp", temp, 160);

    double avg = 0;
    double rms = 0;

    int cnt = 0;

    double lastavg = -1;
    double lastrms = -1;

    double diff  = -1;

    while (file.GetNextRow())
    {
        time += offset;

        if (time>end)
            break;

        double mn = 0;
        double rn = 0;
        for (int i=0; i<=7; i++)
        {
            mn += temp[i];
            rn += temp[i]*temp[i];
        }
        mn /= 8;
        rn /= 8;

        if (time<beg)
        {
            lastavg = mn;
            lastrms = sqrt(rn-mn*mn);
            diff    = beg-time;
            continue;
        }

        avg += mn;
        rms += sqrt(rn-mn*mn);

        cnt ++;
    }

    if (cnt==0)
    {
        if (diff<5./24/3600)
            return;

        cout << "result " << lastavg << ", " << lastrms << endl;
        return;
    }

    avg /= cnt;
    rms /= cnt;

    cout << "result " << avg << ", " << rms << ", " << endl;
}
