#ifndef MARS_MFEnergySlope
#define MARS_MFEnergySlope
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFEnergySlope                                                           //
//                                                                         //
// auth. A.stamerra                                                        //
// created 30.01.03                                                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MFilter
#include "MFilter.h"
#endif

class MParList;
class MMcEvt;
class MMcCorsikaRunHeader;

class MFEnergySlope : public MFilter
{
private:

  Int_t fNumSelectedEvts;
  Int_t fErrors[2];

    MMcEvt *fEvt;
    //    MMcCorsikaRunHeader *fMcRunHeader;

    Bool_t fResult;        
    Float_t fNewSlope;     // New slope set by user 

    Float_t fMcSlope;     // Original energy slope from MC data
    Float_t fMcMinEnergy; // Starting energy of MC data
    Float_t fMcMaxEnergy; // Ending energy of MC data

    Float_t fN0; // Normalization factor

    //    void Init(const Float_t val,
    //          const char *name, const char *title);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

public:

    //    MFEnergySlope(const char *name=NULL, const char *title=NULL);
    //    MFEnergySlope();
    MFEnergySlope(const char *name=NULL, const char *title=NULL);

    Bool_t IsExpressionTrue() const { return fResult; }

    // Slope is used with positive values in the code 
    void SetNewSlope(Float_t f) {fNewSlope = TMath::Abs(f);}
    void SetMcSlope(Float_t f) {fMcSlope = TMath::Abs(f);}

    void SetMcMinEnergy(Float_t f) {fMcMinEnergy = f;}
    void SetMcMaxEnergy(Float_t f) {fMcMaxEnergy = f;}

    ClassDef(MFEnergySlope, 0) // A Filter to select events with a given energy slope
};

#endif






